/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.crafting.conditions.BeeExistsCondition;
import cy.jdkdigital.productivebees.common.crafting.conditions.FluidTagEmptyCondition;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.compat.top.TopPlugin;
import cy.jdkdigital.productivebees.dispenser.CageDispenseBehavior;
import cy.jdkdigital.productivebees.dispenser.ShearsDispenseItemBehavior;
import cy.jdkdigital.productivebees.event.EventHandler;
import cy.jdkdigital.productivebees.event.loot.IngredientModifier;
import cy.jdkdigital.productivebees.event.loot.ItemLootModifier;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModProfessions;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.loot.LootItemKilledByUUIDCondition;
import cy.jdkdigital.productivebees.loot.OptionalLootItem;
import cy.jdkdigital.productivebees.loot.condition.OptionalCopyBlockState;
import cy.jdkdigital.productivebees.network.PacketHandler;
import cy.jdkdigital.productivebees.network.packets.Messages;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="productivebees")
@Mod.EventBusSubscriber(modid="productivebees")
public final class ProductiveBees {
    public static final String MODID = "productivebees";
    public static final RandomSource random = RandomSource.m_216327_();
    public static boolean isDevEnv = false;
    public static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<LootPoolEntryType> LOOT_POOL_ENTRIES = DeferredRegister.create((ResourceKey)Registries.f_257032_, (String)"productivebees");
    public static final DeferredRegister<LootItemFunctionType> LOOT_POOL_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"productivebees");
    public static final DeferredRegister<LootItemConditionType> LOOT_POOL_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"productivebees");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"productivebees");
    public static final RegistryObject<Codec<ItemLootModifier>> ITEM_MODIFIER = LOOT_SERIALIZERS.register("item_modifier", ItemLootModifier.CODEC);
    public static final RegistryObject<Codec<IngredientModifier>> INGREDIENT_MODIFIER = LOOT_SERIALIZERS.register("ingredient_modifier", IngredientModifier.CODEC);
    public static final RegistryObject<LootPoolEntryType> OPTIONAL_LOOT_ITEM = LOOT_POOL_ENTRIES.register("optional_loot_item", () -> new LootPoolEntryType((Serializer)new OptionalLootItem.Serializer()));
    public static final RegistryObject<LootItemFunctionType> OPTIONAL_BLOCK_STATE_PROPERTY = LOOT_POOL_FUNCTIONS.register("optional_copy_block_state", () -> new LootItemFunctionType((Serializer)new OptionalCopyBlockState.Serializer()));
    public static final RegistryObject<LootItemConditionType> KILLED_BY_UUID = LOOT_POOL_CONDITIONS.register("killed_by_uuid", () -> new LootItemConditionType((Serializer)new LootItemKilledByUUIDCondition.Serializer()));
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"productivebees");
    public static ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("productivebees", "productivebees"));
    public static RegistryObject<CreativeModeTab> TAB = CREATIVE_MODE_TABS.register("productivebees", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)Items.f_42785_)).m_257941_((Component)Component.m_237113_((String)"Productive Bees")).m_257652_());

    public ProductiveBees() {
        ModBlocks.registerHives();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onDataSync);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityAttacked);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityHurt);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModPointOfInterestTypes.POI_TYPES.register(modEventBus);
        ModProfessions.PROFESSIONS.register(modEventBus);
        ModFluids.FLUID_TYPES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.HIVE_BEES.register(modEventBus);
        ModEntities.SOLITARY_BEES.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModBlockEntityTypes.BLOCK_ENTITIES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModFeatures.TREE_DECORATORS.register(modEventBus);
        ModFeatures.BIOME_MODIFIERS.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModRecipeTypes.RECIPE_TYPES.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        LOOT_SERIALIZERS.register(modEventBus);
        LOOT_POOL_ENTRIES.register(modEventBus);
        LOOT_POOL_FUNCTIONS.register(modEventBus);
        LOOT_POOL_CONDITIONS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onInterModEnqueue);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(EventHandler::onEntityAttributeCreate);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ProductiveBeesConfig.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ProductiveBeesConfig.CLIENT_CONFIG);
        CraftingHelper.register((IConditionSerializer)FluidTagEmptyCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)BeeExistsCondition.Serializer.INSTANCE);
        ForgeMod.enableMilkFluid();
    }

    public void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopPlugin::new);
    }

    public void onServerStarting(AddReloadListenerEvent event) {
        BeeReloadListener.INSTANCE.context = event.getConditionContext();
        event.addListener((PreparableReloadListener)BeeReloadListener.INSTANCE);
    }

    private void onEntityAttacked(LivingAttackEvent event) {
        ConfigurableBee bee;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ConfigurableBee && (bee = (ConfigurableBee)livingEntity).isIrradiated() && event.getSource().m_19385_().equals("mekanism.radiation")) {
            if (bee.breathCollectionCooldown < 0) {
                bee.breathCollectionCooldown = 600;
                bee.internalSetHasNectar(true);
            } else {
                bee.breathCollectionCooldown = (int)((float)bee.breathCollectionCooldown - event.getAmount());
            }
            event.setCanceled(true);
            bee.m_9236_().m_7605_((Entity)bee, (byte)2);
        }
    }

    private void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ConfigurableBee) {
            ConfigurableBee bee = (ConfigurableBee)livingEntity;
            if (event.getSource().m_19385_().equals("mekanism.radiation") && bee.getBeeType().equals("productivebees:radioactive") && (Double)ProductiveBeesConfig.BEES.deadBeeConvertChance.get() > event.getEntity().m_9236_().f_46441_.m_188500_() && BeeIngredientFactory.getIngredient("productivebees:wasted_radioactive").get() != null) {
                event.setCanceled(true);
                bee.m_21153_(bee.m_21233_());
                bee.setBeeType("productivebees:wasted_radioactive");
            }
        }
    }

    private void onEntityHurt(LivingHurtEvent event) {
        Entity damageSource = event.getSource().m_7639_();
        if (damageSource instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)damageSource;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                boolean isWearingBeeHelmet = false;
                ItemStack itemstack = player.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_() && itemstack.m_41720_().equals(ModItems.BEE_NEST_DIAMOND_HELMET.get())) {
                    isWearingBeeHelmet = true;
                }
                if (isWearingBeeHelmet && player.m_9236_().f_46441_.m_188500_() < (Double)ProductiveBeesConfig.BEES.kamikazBeeChance.get()) {
                    Level level = player.m_9236_();
                    ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(level);
                    BlockPos pos = player.m_20183_();
                    if (bee != null) {
                        bee.setBeeType("productivebees:kamikaz");
                        bee.setDefaultAttributes();
                        bee.m_6710_(attacker);
                        bee.m_7678_(pos.m_123341_(), (double)pos.m_123342_() + 0.5, pos.m_123343_(), bee.m_146908_(), bee.m_146909_());
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                        level.m_5594_(player, pos, SoundEvents.f_11741_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        level.m_7967_((Entity)bee);
                    }
                }
            }
        }
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        ModAdvancements.register();
        ModProfessions.register();
        event.enqueueWork(() -> {
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.STURDY_BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
            DispenserBlock.m_52672_((ItemLike)Items.f_42574_.m_5456_(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        });
    }

    private void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.sendToAllPlayers(new Messages.BeeDataMessage(BeeReloadListener.INSTANCE.getData()));
        } else {
            PacketHandler.sendBeeDataToPlayer(new Messages.BeeDataMessage(BeeReloadListener.INSTANCE.getData()), event.getPlayer());
        }
    }
}

