/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.item.FilterUpgradeItem;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CentrifugeBlockEntity
extends FluidTankBlockEntity
implements UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    private CentrifugeRecipe currentRecipe = null;
    public int recipeProgress = 0;
    public int fluidId = 0;
    public int transferCooldown = -1;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(11, this){

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @Override
        public boolean isContainerItem(Item item) {
            return false;
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            ItemStack existing;
            if (fromAutomation && !(existing = (ItemStack)this.stacks.get(slot)).m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate, fromAutomation);
        }

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            ItemStack currentStack = this.getStackInSlot(slot);
            if (currentStack.m_41613_() == currentStack.m_41741_()) {
                return false;
            }
            boolean isProcessableItem = ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)item) || item.m_41720_().equals(ModItems.GENE_BOTTLE.get()) || item.m_41720_().equals(ModItems.HONEY_TREAT.get()) || CentrifugeBlockEntity.this.canProcessItemStack(item);
            return isProcessableItem && slot == 1 || !isProcessableItem && !super.isInputSlot(slot);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1 && this.getStackInSlot(slot).m_41619_()) {
                CentrifugeBlockEntity.this.recipeProgress = 0;
            }
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CentrifugeBlockEntity.this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)this.getFluid().getFluid());
            CentrifugeBlockEntity.this.m_6596_();
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    static Map<String, CentrifugeRecipe> recipeMap = new HashMap<String, CentrifugeRecipe>();

    public CentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), pos, state);
    }

    public CentrifugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public TimedRecipeInterface getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(TimedRecipeInterface recipe) {
        return (int)((double)(recipe != null ? recipe.getProcessingTime() : ((Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get()).intValue()) * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CentrifugeBlockEntity blockEntity) {
        blockEntity.inventoryHandler.ifPresent(invHandler -> {
            if (!invHandler.getStackInSlot(1).m_41619_() && blockEntity.canOperate()) {
                ItemStack invItem = invHandler.getStackInSlot(1);
                if (invItem.m_41720_().equals(ModItems.GENE_BOTTLE.get())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    int totalTime = blockEntity.getProcessingTime(null);
                    if (++blockEntity.recipeProgress >= totalTime) {
                        blockEntity.completeGeneProcessing((IItemHandlerModifiable)invHandler, level.f_46441_);
                        blockEntity.recipeProgress = 0;
                        blockEntity.m_6596_();
                    }
                } else if (invItem.m_41720_().equals(ModItems.HONEY_TREAT.get())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    int totalTime = blockEntity.getProcessingTime(null);
                    if (++blockEntity.recipeProgress >= totalTime) {
                        blockEntity.completeTreatProcessing((IItemHandlerModifiable)invHandler);
                        blockEntity.recipeProgress = 0;
                        blockEntity.m_6596_();
                    }
                } else {
                    CentrifugeRecipe recipe = blockEntity.getRecipe((IItemHandlerModifiable)invHandler);
                    if (blockEntity.canProcessRecipe(recipe, (IItemHandlerModifiable)invHandler)) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                        int totalTime = blockEntity.getProcessingTime(recipe);
                        if (++blockEntity.recipeProgress >= totalTime) {
                            blockEntity.completeRecipeProcessing(recipe, (IItemHandlerModifiable)invHandler, level.f_46441_);
                            blockEntity.recipeProgress = 0;
                            blockEntity.m_6596_();
                        }
                    }
                }
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
            }
            if (((Boolean)ProductiveBeesConfig.GENERAL.centrifugeHopperMode.get()).booleanValue() && --blockEntity.transferCooldown <= 0) {
                blockEntity.transferCooldown = 22;
                blockEntity.suckInItems((IItemHandlerModifiable)invHandler);
            }
        });
        FluidTankBlockEntity.tick(level, pos, state, blockEntity);
    }

    @Override
    public void tickFluidTank(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (fluidStack.getAmount() > 0) {
                Direction[] directions;
                for (Direction direction : directions = Direction.values()) {
                    BlockEntity te = level.m_7702_(this.f_58858_.m_121945_(direction));
                    if (te == null || fluidStack.getAmount() <= 0) continue;
                    te.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(h -> {
                        int amount = h.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                        if (amount > 0) {
                            amount = h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        }
                    });
                }
            }
        });
    }

    private void suckInItems(IItemHandlerModifiable invHandler) {
        for (ItemEntity itemEntity : this.getCaptureItems()) {
            ItemStack itemStack = itemEntity.m_32055_();
            if (!this.canProcessItemStack(itemStack) && !itemStack.m_41720_().equals(ModItems.GENE_BOTTLE.get()) && (!itemStack.m_41720_().equals(ModItems.HONEY_TREAT.get()) || !HoneyTreat.hasGene(itemStack))) continue;
            CentrifugeBlockEntity.captureItem(invHandler, itemEntity);
        }
    }

    private List<ItemEntity> getCaptureItems() {
        assert (this.f_58857_ != null);
        return Centrifuge.COLLECTION_AREA_SHAPE.m_83299_().stream().flatMap(blockPos -> this.f_58857_.m_6443_(ItemEntity.class, blockPos.m_82386_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    private static void captureItem(IItemHandlerModifiable invHandler, ItemEntity itemEntity) {
        ItemStack leftoverStack = invHandler.insertItem(1, itemEntity.m_32055_(), false);
        if (leftoverStack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(leftoverStack);
        }
    }

    protected boolean canOperate() {
        return true;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public boolean canProcessItemStack(ItemStack stack) {
        InventoryHandlerHelper.ItemHandler inv = new InventoryHandlerHelper.ItemHandler(2, null);
        inv.setStackInSlot(1, stack);
        boolean isAllowedByFilter = true;
        List filterUpgrades = this.getInstalledUpgrades((Item)ModItems.UPGRADE_FILTER.get());
        if (filterUpgrades.size() > 0) {
            isAllowedByFilter = false;
            for (ItemStack filter : filterUpgrades) {
                List<Supplier<BeeIngredient>> allowedBees = FilterUpgradeItem.getAllowedBees(filter);
                block1: for (Supplier<BeeIngredient> allowedBee : allowedBees) {
                    List<ItemStack> produceList = BeeHelper.getBeeProduce(this.f_58857_, (Bee)allowedBee.get().getCachedEntity(this.f_58857_), false);
                    for (ItemStack pStack : produceList) {
                        if (!pStack.m_41720_().equals(stack.m_41720_())) continue;
                        isAllowedByFilter = true;
                        continue block1;
                    }
                }
            }
        }
        CentrifugeRecipe recipe = this.getRecipe((IItemHandlerModifiable)inv);
        return isAllowedByFilter && recipe != null;
    }

    protected CentrifugeRecipe getRecipe(IItemHandlerModifiable inputHandler) {
        ItemStack input;
        if (recipeMap.size() > 5000) {
            recipeMap.clear();
        }
        if ((input = inputHandler.getStackInSlot(1)).m_41619_() || this.f_58857_ == null) {
            return null;
        }
        String cacheKey = ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()) + (input.m_41783_() != null ? input.m_41783_().m_7916_() : "");
        if (!recipeMap.containsKey(cacheKey)) {
            recipeMap.put(cacheKey, BeeHelper.getCentrifugeRecipe(this.f_58857_, inputHandler));
        }
        return recipeMap.getOrDefault(cacheKey, null);
    }

    protected boolean canProcessRecipe(@Nullable CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (recipe != null) {
            ArrayList outputList = Lists.newArrayList();
            recipe.getRecipeOutputs().forEach((stack, value) -> {
                ItemStack item = new ItemStack((ItemLike)stack.m_41720_(), value.get(1).m_7047_());
                outputList.add(item);
            });
            Pair<Fluid, Integer> fluidOutput = recipe.getFluidOutputs();
            boolean fluidFlag = true;
            if (fluidOutput != null) {
                fluidFlag = this.fluidInventory.map(h -> h.getFluidInTank(0).isEmpty() || h.getFluidInTank(0).getFluid().equals(fluidOutput.getFirst())).orElse(false);
            }
            return fluidFlag && ((InventoryHandlerHelper.ItemHandler)invHandler).canFitStacks(outputList);
        }
        return false;
    }

    protected void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler, RandomSource random) {
        recipe.getRecipeOutputs().forEach((itemStack, recipeValues) -> {
            if (random.m_188503_(100) <= recipeValues.get(2).m_7047_()) {
                int count = Mth.m_216271_((RandomSource)random, (int)Mth.m_14143_((float)recipeValues.get(0).m_7047_()), (int)Mth.m_14143_((float)recipeValues.get(1).m_7047_()));
                ItemStack output = itemStack.m_41777_();
                output.m_41764_(count);
                ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(output);
            }
        });
        invHandler.getStackInSlot(1).m_41774_(1);
        Pair<Fluid, Integer> fluidOutput = recipe.getFluidOutputs();
        if (fluidOutput != null) {
            this.fluidInventory.ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)fluidOutput.getFirst(), ((Integer)fluidOutput.getSecond()).intValue()), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    private void completeGeneProcessing(IItemHandlerModifiable invHandler, RandomSource random) {
        ItemStack geneBottle = invHandler.getStackInSlot(1);
        CompoundTag entityData = GeneBottle.getGenes(geneBottle);
        if (entityData == null) {
            return;
        }
        double chance = (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.geneExtractChance.get();
        for (String attributeName : BeeAttributes.attributeList()) {
            if (!(random.m_188500_() <= chance)) continue;
            int value = entityData.m_128451_("bee_" + attributeName);
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack(BeeAttributes.getAttributeByName(attributeName), value));
        }
        if (random.m_188500_() <= chance) {
            int typePurity = (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.typeGenePurity.get();
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack(entityData.m_128461_("type"), random.m_188503_(Math.max(0, typePurity - 5)) + 10));
        }
        invHandler.getStackInSlot(1).m_41774_(1);
    }

    private void completeTreatProcessing(IItemHandlerModifiable invHandler) {
        ItemStack honeyTreat = invHandler.getStackInSlot(1);
        ListTag genes = HoneyTreat.getGenes(honeyTreat);
        if (!genes.isEmpty()) {
            for (Tag inbt : genes) {
                ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
                if (((CompoundTag)inbt).m_128441_("purity")) {
                    int purity = ((CompoundTag)inbt).m_128451_("purity");
                    Gene.setPurity(insertedGene, purity);
                }
                ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(insertedGene);
            }
        }
        invHandler.getStackInSlot(1).m_41774_(1);
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        this.recipeProgress = tag.m_128451_("RecipeProgress");
        Fluid fluid = this.fluidInventory.map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
        this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)fluid);
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        tag.m_128405_("RecipeProgress", this.recipeProgress);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return Component.m_237115_((String)((Block)ModBlocks.CENTRIFUGE.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new CentrifugeContainer(windowId, playerInventory, this);
    }
}

