/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.container.IncubatorContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeCreator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class IncubatorBlockEntity
extends CapabilityBlockEntity
implements UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    public int recipeProgress = 0;
    public boolean isRunning = false;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(3, this){

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot == 0 && item.m_41720_() instanceof BeeCage || slot == 0 && item.m_204117_(ModTags.Forge.EGGS) || slot == 1 && item.m_41720_() instanceof HoneyTreat;
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(10000));

    private void setRunning(boolean running) {
        this.isRunning = running;
    }

    public IncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.INCUBATOR.get(), pos, state);
    }

    @Override
    public TimedRecipeInterface getCurrentRecipe() {
        return null;
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(TimedRecipeInterface recipe) {
        return (int)((double)(recipe != null ? recipe.getProcessingTime() : 3600) * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, IncubatorBlockEntity blockEntity) {
        if (blockEntity.isRunning && level instanceof ServerLevel) {
            blockEntity.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false));
        }
        blockEntity.inventoryHandler.ifPresent(invHandler -> {
            if (!invHandler.getStackInSlot(0).m_41619_()) {
                if (blockEntity.isRunning || blockEntity.canProcessInput((IItemHandlerModifiable)invHandler)) {
                    blockEntity.setRunning(true);
                    int totalTime = blockEntity.getProcessingTime(null);
                    if (++blockEntity.recipeProgress >= totalTime) {
                        blockEntity.completeIncubation((IItemHandlerModifiable)invHandler, level.f_46441_);
                        blockEntity.recipeProgress = 0;
                        blockEntity.m_6596_();
                    }
                }
            } else {
                blockEntity.recipeProgress = 0;
                blockEntity.setRunning(false);
            }
        });
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier);
    }

    private boolean canProcessInput(IItemHandlerModifiable invHandler) {
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        ItemStack inItem = invHandler.getStackInSlot(0);
        ItemStack treatItem = invHandler.getStackInSlot(1);
        boolean eggProcessing = inItem.m_204117_(ModTags.Forge.EGGS);
        boolean cageProcessing = inItem.m_41720_() instanceof BeeCage && BeeCage.isFilled(inItem);
        return energy > (Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get() && (eggProcessing || cageProcessing) && invHandler.getStackInSlot(2).m_41619_() && treatItem.m_41720_().equals(ModItems.HONEY_TREAT.get()) && (cageProcessing && (treatItem.m_41613_() >= (Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get() || HoneyTreat.hasGene(treatItem) && !HoneyTreat.hasBeeType(treatItem)) || eggProcessing && !treatItem.m_41619_() && HoneyTreat.hasBeeType(treatItem));
    }

    private void completeIncubation(IItemHandlerModifiable invHandler, RandomSource random) {
        if (this.canProcessInput(invHandler)) {
            ItemStack inItem = invHandler.getStackInSlot(0).m_41777_();
            boolean eggProcessing = inItem.m_204117_(ModTags.Forge.EGGS);
            boolean cageProcessing = inItem.m_41720_() instanceof BeeCage;
            if (cageProcessing) {
                ItemStack treat = invHandler.getStackInSlot(1);
                if (HoneyTreat.hasGene(treat)) {
                    Bee entity = BeeCage.getEntityFromStack(inItem, this.f_58857_, true);
                    if (entity instanceof ProductiveBee) {
                        ProductiveBee pBee = (ProductiveBee)entity;
                        HoneyTreat.applyGenesToBee(this.f_58857_, treat, pBee);
                        ItemStack newBeeStack = new ItemStack((ItemLike)inItem.m_41720_());
                        BeeCage.captureEntity(pBee, newBeeStack);
                        invHandler.setStackInSlot(2, newBeeStack);
                        invHandler.getStackInSlot(0).m_41774_(1);
                        treat.m_41774_(1);
                    }
                } else {
                    CompoundTag nbt = inItem.m_41783_();
                    if (nbt != null && nbt.m_128441_("Age")) {
                        nbt.m_128405_("Age", 0);
                    }
                    inItem.m_41764_(1);
                    invHandler.setStackInSlot(2, inItem);
                    treat.m_41774_(((Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get()).intValue());
                    invHandler.getStackInSlot(0).m_41774_(1);
                }
            } else if (eggProcessing) {
                ItemStack treatItem = invHandler.getStackInSlot(1);
                ListTag genes = HoneyTreat.getGenes(treatItem);
                for (Tag inbt : genes) {
                    ItemStack egg;
                    ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
                    String beeName = Gene.getAttributeName(insertedGene);
                    if (beeName.isEmpty()) continue;
                    int purity = Gene.getPurity(insertedGene);
                    if (((CompoundTag)inbt).m_128441_("purity")) {
                        purity = ((CompoundTag)inbt).m_128451_("purity");
                    }
                    if (random.m_188503_(100) > purity || !((egg = BeeCreator.getSpawnEgg(beeName)).m_41720_() instanceof SpawnEggItem)) continue;
                    invHandler.setStackInSlot(2, egg);
                }
                invHandler.getStackInSlot(0).m_41774_(1);
                treatItem.m_41774_(1);
            }
        }
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void m_6596_() {
        super.m_6596_();
        this.setRunning(false);
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        this.recipeProgress = tag.m_128451_("RecipeProgress");
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        tag.m_128405_("RecipeProgress", this.recipeProgress);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        return Component.m_237115_((String)((Block)ModBlocks.INCUBATOR.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new IncubatorContainer(windowId, playerInventory, this);
    }
}

