/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.UpgradeItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryHandlerHelper {
    public static final int BOTTLE_SLOT = 0;
    public static final int INPUT_SLOT = 1;
    public static final int FLUID_ITEM_OUTPUT_SLOT = 11;
    public static final int[] OUTPUT_SLOTS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};

    private static int getAvailableOutputSlot(ItemHandler handler, ItemStack insertStack) {
        return InventoryHandlerHelper.getAvailableOutputSlot(handler, insertStack, new ArrayList<Integer>());
    }

    private static int getAvailableOutputSlot(ItemHandler handler, ItemStack insertStack, List<Integer> blacklistedSlots) {
        int emptySlot = 0;
        for (int slot : handler.getOutputSlots()) {
            if (blacklistedSlots.contains(slot)) continue;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_() && emptySlot == 0) {
                emptySlot = slot;
                continue;
            }
            if (!stack.m_41720_().equals(insertStack.m_41720_()) || stack.m_41613_() + insertStack.m_41613_() > stack.m_41741_() || !(!Gene.getAttributeName(insertStack).isEmpty() ? Gene.getAttributeName(stack).equals(Gene.getAttributeName(insertStack)) && Gene.getValue(stack).equals(Gene.getValue(insertStack)) && Gene.getPurity(stack).equals(Gene.getPurity(insertStack)) : stack.m_41619_() || InventoryHandlerHelper.areItemsAndTagsEqual(stack, insertStack))) continue;
            return slot;
        }
        return emptySlot;
    }

    public static boolean areItemsAndTagsEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41619_() && stack2.m_41619_() || stack1.m_41720_() == stack2.m_41720_() && InventoryHandlerHelper.areItemStackTagsEqual(stack1, stack2);
    }

    public static boolean areItemStackTagsEqual(ItemStack stackA, ItemStack stackB) {
        if (!stackA.m_41619_() && !stackB.m_41619_()) {
            CompoundTag tagA = stackA.m_41783_();
            CompoundTag tagB = stackB.m_41783_();
            if ((tagA == null || tagA.m_128456_()) && tagB != null && !tagB.m_128456_()) {
                return false;
            }
            return (tagA == null || tagA.m_128456_() || tagA.equals((Object)stackB.m_41783_())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    public static class ItemHandler
    extends ItemStackHandler {
        protected BlockEntity blockEntity;

        public ItemHandler(int size) {
            this(size, null);
        }

        public ItemHandler(int size, @Nullable BlockEntity blockEntity) {
            super(size);
            this.blockEntity = blockEntity;
        }

        public int[] getOutputSlots() {
            return OUTPUT_SLOTS;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.blockEntity != null) {
                this.blockEntity.m_6596_();
            }
        }

        public boolean isInputSlot(int slot) {
            return slot == 0 || slot == 1;
        }

        public boolean isInsertableSlot(int slot) {
            return slot != 0 && slot != 1 && slot != 11;
        }

        public boolean isContainerItem(Item item) {
            return item == Items.f_42590_;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot == 0 && this.isContainerItem(item.m_41720_()) || slot == 11 && !this.isContainerItem(item.m_41720_());
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.isItemValid(slot, stack, true);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            return !fromAutomation && this.isInsertableSlot(slot);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extractItem(slot, amount, simulate, true);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean fromAutomation) {
            if (fromAutomation && this.isInputSlot(slot)) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.insertItem(slot, stack, simulate, true);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack addOutput(@Nonnull ItemStack stack) {
            LinkedList<Integer> outputStacks = new LinkedList<Integer>();
            while (stack.m_41613_() > 0) {
                if (stack.m_41613_() <= 64) {
                    outputStacks.add(stack.m_41613_());
                    break;
                }
                outputStacks.add(64);
                stack.m_41764_(stack.m_41613_() - 64);
            }
            Iterator iterator = outputStacks.iterator();
            while (iterator.hasNext()) {
                stack.m_41764_(((Integer)iterator.next()).intValue());
                int slot = InventoryHandlerHelper.getAvailableOutputSlot(this, stack);
                if (slot <= 0) continue;
                ItemStack existingStack = this.getStackInSlot(slot);
                if (existingStack.m_41619_()) {
                    this.setStackInSlot(slot, stack.m_41777_());
                } else {
                    existingStack.m_41769_(stack.m_41613_());
                }
                this.onContentsChanged(slot);
                iterator.remove();
            }
            stack.m_41764_(outputStacks.stream().mapToInt(Integer::intValue).sum());
            return stack;
        }

        public boolean canFitStacks(List<ItemStack> stacks) {
            ArrayList<Integer> usedSlots = new ArrayList<Integer>();
            for (ItemStack stack : stacks) {
                int slot = InventoryHandlerHelper.getAvailableOutputSlot(this, stack, usedSlots);
                if (slot != 0) continue;
                return false;
            }
            return true;
        }

        public void deserializeNBT(CompoundTag nbt) {
            int size;
            int n = size = nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size();
            if (size < this.stacks.size()) {
                nbt.m_128405_("Size", this.stacks.size());
            }
            super.deserializeNBT(nbt);
        }
    }

    public static class FluidHandler
    extends FluidTank
    implements INBTSerializable<CompoundTag> {
        public FluidHandler(int capacity) {
            super(capacity);
        }

        public FluidHandler(int capacity, Predicate<FluidStack> validator) {
            super(capacity, validator);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            this.fluid.writeToNBT(nbt);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        }
    }

    public static class UpgradeHandler
    extends ItemHandler {
        public UpgradeHandler(int size, BlockEntity tileEntity) {
            super(size, tileEntity);
        }

        @Override
        public boolean isInsertableSlot(int slot) {
            return false;
        }

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            return item.m_41720_() instanceof UpgradeItem;
        }
    }
}

