/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.compat.harvest.HarvestCompatHandler;
import cy.jdkdigital.productivebees.init.ModItems;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FarmerBee
extends ProductiveBee {
    public static final UUID FARMER_BEE_UUID = UUID.nameUUIDFromBytes("pb_farmer_bee".getBytes(StandardCharsets.UTF_8));
    private BlockPos targetHarvestPos = null;
    private LocateCropGoal locateCropGoal;

    public FarmerBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_21345_.m_25352_(4, (Goal)new HarvestCropGoal());
        this.locateCropGoal = new LocateCropGoal();
        this.f_21345_.m_25352_(6, (Goal)this.locateCropGoal);
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        return source.equals(this.m_9236_().m_269111_().m_269325_()) || super.m_6673_(source);
    }

    public List<BlockPos> findHarvestablesNearby(BlockPos pos, int distance) {
        List<BlockPos> list = BlockPos.m_121990_((BlockPos)pos.m_7918_(-distance, -distance + 2, -distance), (BlockPos)pos.m_7918_(distance, distance - 2, distance)).map(BlockPos::m_7949_).collect(Collectors.toList());
        list.removeIf(blockPos -> this.m_9236_().m_8055_(blockPos).m_60795_());
        list.removeIf(blockPos -> !this.isCropValid((BlockPos)blockPos));
        return list;
    }

    public boolean isCropValid(BlockPos blockPos) {
        return HarvestCompatHandler.isCropValid(this, blockPos);
    }

    public void harvestBlock(BlockPos pos) {
        if (pos != null) {
            HarvestCompatHandler.harvestBlock(this, pos);
        }
    }

    public class HarvestCropGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            if (FarmerBee.this.targetHarvestPos != null && !this.positionIsHarvestable(FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.m_21660_() && !FarmerBee.this.m_27816_(FarmerBee.this.targetHarvestPos, 2);
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8037_() {
            if (FarmerBee.this.targetHarvestPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    FarmerBee.this.locateCropGoal.cooldown = 120;
                    FarmerBee.this.targetHarvestPos = null;
                } else if (!FarmerBee.this.f_21344_.m_26571_()) {
                    BlockPos blockPos = FarmerBee.this.targetHarvestPos;
                    FarmerBee.this.f_21344_.m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
                }
            }
        }

        private boolean positionIsHarvestable(BlockPos pos) {
            return !FarmerBee.this.findHarvestablesNearby(pos, 0).isEmpty();
        }
    }

    public class LocateCropGoal
    extends Goal {
        private int ticks = 0;
        private int cooldown = 0;

        public boolean m_8036_() {
            if (--this.cooldown <= 0 && !FarmerBee.this.m_21660_()) {
                FarmerBee.this.targetHarvestPos = this.findNearestHarvestableTarget();
                if (FarmerBee.this.targetHarvestPos == null) {
                    this.cooldown = 70;
                }
            }
            return FarmerBee.this.targetHarvestPos != null;
        }

        public boolean m_8045_() {
            if (FarmerBee.this.f_19797_ % 20 == 0 && !FarmerBee.this.isCropValid(FarmerBee.this.targetHarvestPos)) {
                FarmerBee.this.targetHarvestPos = null;
            }
            return FarmerBee.this.targetHarvestPos != null && !FarmerBee.this.m_21660_();
        }

        private BlockPos findNearestHarvestableTarget() {
            AdvancedBeehiveBlockEntity beehiveBlockEntity;
            int radius;
            List<BlockPos> harvestablesNearby;
            BlockEntity hive;
            if (FarmerBee.this.f_27698_ != null && (hive = FarmerBee.this.m_9236_().m_7702_(FarmerBee.this.f_27698_)) instanceof AdvancedBeehiveBlockEntity && !(harvestablesNearby = FarmerBee.this.findHarvestablesNearby(FarmerBee.this.f_27698_, radius = 5 + (beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hive).getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get()))).isEmpty()) {
                BlockPos nearest = null;
                double nearestDistance = 0.0;
                for (BlockPos pos : harvestablesNearby) {
                    double distance = pos.m_123331_((Vec3i)FarmerBee.this.m_20183_());
                    if (nearestDistance != 0.0 && !(distance <= nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = pos;
                }
                return nearest;
            }
            return null;
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8037_() {
            ++this.ticks;
            if (FarmerBee.this.targetHarvestPos != null) {
                if (this.ticks > 600) {
                    FarmerBee.this.targetHarvestPos = null;
                } else {
                    Vec3 vec3d = Vec3.m_82512_((Vec3i)FarmerBee.this.targetHarvestPos).m_82520_(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.m_82554_(FarmerBee.this.m_20182_());
                    if (distanceToTarget > 1.5) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        FarmerBee.this.locateCropGoal.cooldown = 120;
                        FarmerBee.this.targetHarvestPos = null;
                    } else {
                        BlockPos pos = FarmerBee.this.targetHarvestPos;
                        if (FarmerBee.this.m_9236_().m_46749_(pos) && FarmerBee.this.isCropValid(pos)) {
                            FarmerBee.this.harvestBlock(pos);
                        }
                        FarmerBee.this.targetHarvestPos = null;
                        FarmerBee.this.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 nextTarget) {
            FarmerBee.this.m_21566_().m_6849_(nextTarget.f_82479_, nextTarget.f_82480_, nextTarget.f_82481_, 1.0);
        }
    }
}

