/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class NestLocator
extends Item {
    private static final String KEY = "productivebees_locator_nest";

    public NestLocator(Item.Properties properties) {
        super(properties);
    }

    public static String getNestName(ItemStack stack) {
        if (!NestLocator.hasNest(stack)) {
            return Blocks.f_50717_.m_49954_().getString();
        }
        CompoundTag nbt = stack.m_41784_().m_128469_(KEY);
        return nbt.m_128441_("nestName") ? nbt.m_128461_("nestName") : null;
    }

    public static String getNestRegistryName(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_().m_128469_(KEY);
        return nbt.m_128441_("nest") ? nbt.m_128461_("nest") : null;
    }

    public static Block getNestBlock(ItemStack stack) {
        String registryName = NestLocator.getNestRegistryName(stack);
        if (registryName != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
        }
        return null;
    }

    public static void setNestBlock(ItemStack stack, @Nullable Block nest, Player player) {
        CompoundTag nbt = stack.m_41784_().m_128469_(KEY);
        nbt.m_128473_("nest");
        if (nest != null && ForgeRegistries.BLOCKS.getKey((Object)nest) != null) {
            nbt.m_128359_("nest", ForgeRegistries.BLOCKS.getKey((Object)nest).toString());
            nbt.m_128359_("nestName", Component.m_237115_((String)nest.m_7705_()).getString());
            player.m_5661_((Component)Component.m_237110_((String)"productivebees.nest_locator.tuned", (Object[])new Object[]{nbt.m_128461_("nestName")}), false);
        }
        stack.m_41784_().m_128365_(KEY, (Tag)nbt);
    }

    public static boolean hasNest(ItemStack stack) {
        return NestLocator.getNestRegistryName(stack) != null;
    }

    public static BlockPos getPosition(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_().m_128469_(KEY);
        return nbt.m_128441_("position") ? BlockPos.m_122022_((long)nbt.m_128454_("position")) : null;
    }

    public static void setPosition(ItemStack stack, @Nullable BlockPos pos) {
        CompoundTag nbt = stack.m_41784_().m_128469_(KEY);
        if (pos != null) {
            nbt.m_128356_("position", pos.m_121878_());
        } else {
            nbt.m_128473_("position");
        }
        stack.m_41784_().m_128365_(KEY, (Tag)nbt);
    }

    public static boolean hasPosition(ItemStack stack) {
        return NestLocator.getPosition(stack) != null;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.f_46443_ && context.m_43723_() != null && context.m_43723_().m_6144_()) {
            ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
            BlockState state = world.m_8055_(context.m_8083_());
            Block block = state.m_60734_();
            if (block instanceof BeehiveBlock || block instanceof AdvancedBeehive) {
                NestLocator.setNestBlock(stack, Blocks.f_50717_, context.m_43723_());
            } else if (block instanceof SolitaryNest) {
                NestLocator.setNestBlock(stack, block, context.m_43723_());
            } else if (ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_().contains("warped")) {
                NestLocator.setNestBlock(stack, (Block)ModBlocks.WARPED_BEE_NEST.get(), context.m_43723_());
            } else if (ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_().contains("crimson")) {
                NestLocator.setNestBlock(stack, (Block)ModBlocks.CRIMSON_BEE_NEST.get(), context.m_43723_());
            } else {
                ProductiveBees.LOGGER.info("find nest based on block " + block);
                Block nest = SolitaryNest.BLOCK_TO_NEST.get().get(block);
                ProductiveBees.LOGGER.info("found " + nest);
                if (nest instanceof SolitaryNest) {
                    NestLocator.setNestBlock(stack, nest, context.m_43723_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        if (!world.f_46443_ && world instanceof ServerLevel) {
            ItemStack stack = player.m_21120_(hand);
            if (!player.m_6144_()) {
                Pair<Double, BlockPos> nearest;
                Predicate<Block> predicate = o -> o instanceof BeehiveBlock;
                if (NestLocator.hasNest(stack)) {
                    predicate = o -> o.equals(NestLocator.getNestBlock(stack));
                }
                if ((nearest = this.findNearestNest((ServerLevel)world, player.m_20183_(), (Integer)ProductiveBeesConfig.GENERAL.nestLocatorDistance.get(), predicate)) != null) {
                    player.m_5661_((Component)Component.m_237110_((String)"productivebees.nest_locator.found_hive", (Object[])new Object[]{(double)Math.round((Double)nearest.getFirst() * 100.0) / 100.0}), false);
                    NestLocator.setPosition(stack, (BlockPos)nearest.getSecond());
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"productivebees.nest_locator.not_found_hive", (Object[])new Object[]{NestLocator.getNestName(stack)}), false);
                    NestLocator.setPosition(stack, null);
                }
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        if (NestLocator.hasNest(stack)) {
            tooltip.add((Component)Component.m_237110_((String)"productivebees.information.nestlocator.configured", (Object[])new Object[]{NestLocator.getNestName(stack)}).m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"productivebees.information.nestlocator.unconfigured").m_130940_(ChatFormatting.GOLD));
        }
    }

    private Pair<Double, BlockPos> findNearestNest(ServerLevel world, BlockPos pos, int distance, Predicate<Block> predicate) {
        Vec3 playerPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        PoiManager poiManager = world.m_8904_();
        Stream stream = poiManager.m_27166_(poi -> poi.m_203656_(PoiTypeTags.f_215877_) || poi.m_203334_() == ModPointOfInterestTypes.SOLITARY_HIVE.get() || poi.m_203334_() == ModPointOfInterestTypes.SOLITARY_NEST.get() || poi.m_203334_() == ModPointOfInterestTypes.DRACONIC_NEST.get() || poi.m_203334_() == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get() || poi.m_203334_() == ModPointOfInterestTypes.NETHER_NEST.get() || poi.m_203334_() == ModPointOfInterestTypes.SUGARBAG_NEST.get(), pos, distance, PoiManager.Occupancy.ANY);
        List nearbyNestPositions = stream.map(PoiRecord::m_27257_).filter(nestPos -> {
            BlockState state = world.m_8055_(nestPos);
            return predicate.test(state.m_60734_());
        }).sorted(Comparator.comparingDouble(vec -> vec.m_123331_((Vec3i)pos))).collect(Collectors.toList());
        if (!nearbyNestPositions.isEmpty()) {
            BlockPos nearestPos = (BlockPos)nearbyNestPositions.iterator().next();
            double distanceToNest = playerPos.m_82554_(new Vec3((double)nearestPos.m_123341_(), (double)nearestPos.m_123342_(), (double)nearestPos.m_123343_()));
            return new Pair((Object)distanceToNest, (Object)nearestPos);
        }
        return null;
    }
}

