/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.init.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeRecipeCategory
implements IRecipeCategory<CentrifugeRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/centrifuge_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CENTRIFUGE.get()));
    }

    public RecipeType<CentrifugeRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.CENTRIFUGE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.productivebees.centrifuge");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CentrifugeRecipe recipe, IFocusGroup focuses) {
        Pair<Fluid, Integer> fluid;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 27).addItemStacks(Arrays.stream(recipe.ingredient.m_43908_()).toList())).setSlotName("ingredient");
        int startX = 68;
        int startY = 26;
        int[] i = new int[]{0};
        if (recipe.getRecipeOutputs().size() > 0) {
            recipe.getRecipeOutputs().forEach((stack, value) -> {
                ArrayList innerList = new ArrayList();
                IntStream.range(value.get(0).m_7047_(), value.get(1).m_7047_() + 1).forEach(u -> {
                    ItemStack newStack = stack.m_41777_();
                    newStack.m_41764_(u);
                    innerList.add(newStack);
                });
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18 + 1, startY + (int)Math.floor((float)i[0] / 3.0f) * 18 + 1).addItemStacks(innerList)).addTooltipCallback((recipeSlotView, tooltip) -> {
                    int chance = value.get(2).m_7047_();
                    if (chance < 100) {
                        tooltip.add(Component.m_237110_((String)"productivebees.centrifuge.tooltip.chance", (Object[])new Object[]{chance < 1 ? "<1%" : chance + "%"}));
                    } else {
                        tooltip.add(Component.m_237113_((String)""));
                    }
                    if (value.get(0) != value.get(1)) {
                        tooltip.add(Component.m_237110_((String)"productivebees.centrifuge.tooltip.amount", (Object[])new Object[]{value.get(0).m_7047_() + " - " + value.get(1).m_7047_()}));
                    } else {
                        tooltip.add(Component.m_237113_((String)""));
                    }
                }).setSlotName("output" + i[0]);
                i[0] = i[0] + 1;
            });
        }
        if ((fluid = recipe.getFluidOutputs()) != null && (Integer)fluid.getSecond() > 0) {
            int fluidAmount = (Integer)fluid.getSecond() < 250 ? (Integer)fluid.getSecond() * 4 : (Integer)fluid.getSecond();
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i[0] * 18 + 1, startY + (int)Math.floor((float)i[0] / 3.0f) * 18 + 1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack((Fluid)fluid.getFirst(), fluidAmount))).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(Component.m_237110_((String)"productivebees.centrifuge.tooltip.amount", (Object[])new Object[]{fluid.getSecond() + "mB"}))).setSlotName("output" + i[0]);
        }
    }
}

