/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Incubator;
import cy.jdkdigital.productivebees.common.block.entity.IncubatorBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.container.ManualSlotItemHandler;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class IncubatorContainer
extends AbstractContainer {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_CATALYST = 1;
    public static final int SLOT_OUTPUT = 2;
    public final IncubatorBlockEntity tileEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public IncubatorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, IncubatorContainer.getTileEntity(playerInventory, data));
    }

    public IncubatorContainer(int windowId, Inventory playerInventory, IncubatorBlockEntity tileEntity) {
        this((MenuType)ModContainerTypes.INCUBATOR.get(), windowId, playerInventory, tileEntity);
    }

    public IncubatorContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, final IncubatorBlockEntity tileEntity) {
        super(type, windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            }

            public void m_6422_(int value) {
                tileEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                    if (handler.getEnergyStored() > 0) {
                        handler.extractEnergy(handler.getEnergyStored(), false);
                    }
                    if (value > 0) {
                        handler.receiveEnergy(value, false);
                    }
                });
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return tileEntity.recipeProgress;
            }

            public void m_6422_(int value) {
                tileEntity.recipeProgress = value;
            }
        });
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 0, 39, 35));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 1, 67, 53));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 2, 95, 35));
        });
        this.tileEntity.getUpgradeHandler().ifPresent(upgradeHandler -> this.addSlotBox((IItemHandler)upgradeHandler, 0, 165, 8, 1, 18, 4, 18));
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static IncubatorBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof IncubatorBlockEntity) {
            return (IncubatorBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof Incubator && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getBlockEntity() {
        return this.tileEntity;
    }
}

