/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public interface Train
extends Iterable<RollingStock> {
    public UUID id();

    public RollingStock front();

    public void copyTo(Train var1);

    default public Stream<RollingStock> stream() {
        return this.front().traverseTrainWithSelf(Side.BACK);
    }

    default public Stream<? extends AbstractMinecart> entities() {
        return this.stream().map(RollingStock::entity);
    }

    default public Stream<Entity> passengers() {
        return this.entities().flatMap(minecart -> minecart.m_20197_().stream());
    }

    @Override
    default public Iterator<RollingStock> iterator() {
        return this.stream().iterator();
    }

    public int getNumRunningLocomotives();

    default public int size() {
        return (int)this.stream().count();
    }

    public State state();

    public void setState(State var1);

    default public void setStateIfHigherPriority(State state) {
        if (state.ordinal() < this.state().ordinal()) {
            this.setState(state);
        }
    }

    public void addLock(UUID var1);

    public void removeLock(UUID var1);

    public boolean isLocked();

    default public boolean isIdle() {
        return this.state() == State.IDLE || this.isLocked();
    }

    public Optional<IItemHandler> itemHandler();

    public Optional<IFluidHandler> fluidHandler();

    public static enum State implements StringRepresentable
    {
        STOPPED("stopped"),
        IDLE("idle"),
        NORMAL("normal");

        private static final Map<String, State> byName;
        private final String name;

        private State(String name) {
            this.name = name;
        }

        public boolean isStopped() {
            return this == STOPPED;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Optional<State> getByName(String name) {
            return Optional.ofNullable(byName.get(name));
        }

        static {
            byName = Arrays.stream(State.values()).collect(Collectors.toUnmodifiableMap(State::m_7912_, Function.identity()));
        }
    }
}

