/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.charge;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface ChargeBlock {
    default public Map<Charge, Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return Collections.emptyMap();
    }

    @Nullable
    default public Charge.Access getMeterAccess(Charge network, BlockState state, ServerLevel level, BlockPos pos) {
        return network.network(level).access(pos);
    }

    default public void registerNode(BlockState state, ServerLevel level, BlockPos pos) {
        EnumSet.allOf(Charge.class).forEach(n -> n.network(level).addNode(pos, state));
    }

    default public void deregisterNode(ServerLevel level, BlockPos pos) {
        EnumSet.allOf(Charge.class).forEach(n -> n.network(level).removeNode(pos));
    }

    public record Spec(ConnectType connectType, float losses, @Nullable ChargeStorage.Spec storageSpec) {
        public Spec(ConnectType connectType, float losses) {
            this(connectType, losses, null);
        }

        public static Map<Charge, Spec> make(Charge network, ConnectType connectType, float losses) {
            return Map.of(network, new Spec(connectType, losses));
        }

        public static Map<Charge, Spec> make(Charge network, ConnectType connectType, float losses, @Nullable ChargeStorage.Spec storageSpec) {
            return Map.of(network, new Spec(connectType, losses, storageSpec));
        }
    }

    public static enum ConnectType {
        BLOCK,
        SLAB,
        TRACK,
        WIRE;

    }
}

