/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.client.gui.widget.button.ToggleButton;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetActionSignalBoxAttributesMessage;
import mods.railcraft.world.level.block.entity.signal.ActionSignalBoxBlockEntity;
import mods.railcraft.world.level.block.entity.signal.LockableSignalBoxBlockEntity;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ActionSignalBoxScreen
extends IngameWindowScreen {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final ActionSignalBoxBlockEntity signalBox;
    private final Map<SignalAspect, ToggleButton> signalAspectButtons = new EnumMap<SignalAspect, ToggleButton>(SignalAspect.class);
    private MultiButton<LockableSignalBoxBlockEntity.Lock> lockButton;
    private int refreshTimer;

    public ActionSignalBoxScreen(ActionSignalBoxBlockEntity signalBox) {
        super(signalBox.m_5446_());
        this.signalBox = signalBox;
    }

    public void m_7856_() {
        int centreX = (this.f_96543_ - this.windowWidth) / 2;
        int centreY = (this.f_96544_ - this.windowHeight) / 2;
        this.addSignalAspectButton(SignalAspect.GREEN, centreX + 7, centreY + 30, 50);
        this.addSignalAspectButton(SignalAspect.YELLOW, centreX + 63, centreY + 30, 50);
        this.addSignalAspectButton(SignalAspect.RED, centreX + 119, centreY + 30, 50);
        this.addSignalAspectButton(SignalAspect.BLINK_YELLOW, centreX + 12, centreY + 55, 70);
        this.addSignalAspectButton(SignalAspect.BLINK_RED, centreX + 94, centreY + 55, 70);
        this.lockButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.signalBox.getLock()).bounds(centreX + 152, centreY + 8, 16, 16)).tooltipFactory(this::updateLockButtonTooltip).stateCallback(this::setLock).build()));
        this.updateButtons();
    }

    private void addSignalAspectButton(SignalAspect signalAspect, int x, int y, int width) {
        EnumSet<SignalAspect> actionSignalAspects = this.signalBox.getActionSignalAspects();
        ToggleButton button = (ToggleButton)this.m_142416_((GuiEventListener)((ToggleButton)((ToggleButton.Builder)ToggleButton.toggleBuilder(signalAspect.getDisplayName(), btn -> ((ToggleButton)btn).setToggled(this.toggleSignalAspect(signalAspect)), ButtonTexture.LARGE_BUTTON).bounds(x, y, width, 20)).toggled(actionSignalAspects.contains((Object)signalAspect)).build()));
        this.signalAspectButtons.put(signalAspect, button);
    }

    private void setLock(LockableSignalBoxBlockEntity.Lock lock) {
        if (this.signalBox.getLock() != lock) {
            this.signalBox.setLock(lock);
            this.signalBox.setOwner(lock == LockableSignalBoxBlockEntity.Lock.UNLOCKED ? null : this.f_96541_.m_91094_().m_92548_());
            this.sendAttributes();
        }
    }

    private Optional<Tooltip> updateLockButtonTooltip(LockableSignalBoxBlockEntity.Lock lock) {
        return Optional.of(Tooltip.m_257550_((Component)(switch (lock) {
            default -> throw new IncompatibleClassChangeError();
            case LockableSignalBoxBlockEntity.Lock.LOCKED -> Component.m_237110_((String)Translations.Screen.ACTION_SIGNAL_BOX_LOCKED, (Object[])new Object[]{this.signalBox.getOwnerOrThrow().getName()});
            case LockableSignalBoxBlockEntity.Lock.UNLOCKED -> Component.m_237115_((String)Translations.Screen.ACTION_SIGNAL_BOX_UNLOCKED);
        })));
    }

    private boolean toggleSignalAspect(SignalAspect signalAspect) {
        boolean toggled = false;
        if (!this.signalBox.getActionSignalAspects().remove((Object)signalAspect)) {
            this.signalBox.getActionSignalAspects().add(signalAspect);
            toggled = true;
        }
        this.sendAttributes();
        return toggled;
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.refreshTimer++ >= 20) {
            this.refreshTimer = 0;
            this.updateButtons();
        }
    }

    private void updateButtons() {
        boolean canAccess;
        this.lockButton.f_93623_ = canAccess = this.signalBox.canAccess(this.f_96541_.m_91094_().m_92548_());
        this.lockButton.setState(this.signalBox.getLock());
        this.signalAspectButtons.forEach((signalAspect, button) -> {
            button.f_93623_ = canAccess;
            button.setToggled(this.signalBox.getActionSignalAspects().contains(signalAspect));
        });
    }

    private void sendAttributes() {
        if (!this.signalBox.canAccess(this.f_96541_.m_91094_().m_92548_())) {
            return;
        }
        NetworkChannel.GAME.sendToServer(new SetActionSignalBoxAttributesMessage(this.signalBox.m_58899_(), this.signalBox.getActionSignalAspects(), this.lockButton.getState()));
    }
}

