/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.world.inventory.ManipulatorMenu;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;

public abstract class ManipulatorScreen<T extends ManipulatorMenu<?>>
extends RailcraftMenuScreen<T> {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private static final Component CART_FILTER_TEXT = Component.m_237115_((String)Translations.Screen.CART_FILTERS);
    private MultiButton<ManipulatorBlockEntity.RedstoneMode> redstoneModeButton;
    private int refreshTimer;

    protected ManipulatorScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    public void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        this.redstoneModeButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, ((ManipulatorBlockEntity)((ManipulatorMenu)this.f_97732_).getManipulator()).getRedstoneMode()).bounds(centreX + 73, centreY + 62, 30, 16)).stateCallback(this::setRedstoneMode).build()));
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    private void setRedstoneMode(ManipulatorBlockEntity.RedstoneMode redstoneMode) {
        if (redstoneMode != ((ManipulatorBlockEntity)((ManipulatorMenu)this.f_97732_).getManipulator()).getRedstoneMode()) {
            ((ManipulatorBlockEntity)((ManipulatorMenu)this.f_97732_).getManipulator()).setRedstoneMode(redstoneMode);
            this.sendAttributes();
        }
    }

    protected abstract void sendAttributes();

    public void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.refreshTimer = 0;
            this.refresh();
        }
    }

    protected void refresh() {
        this.redstoneModeButton.setState(((ManipulatorBlockEntity)((ManipulatorMenu)this.f_97732_).getManipulator()).getRedstoneMode());
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x333333, false);
        if (((ManipulatorMenu)this.m_6262_()).hasCartFilter()) {
            guiGraphics.m_280614_(this.f_96547_, CART_FILTER_TEXT, 75, 16, -12566464, false);
        }
    }
}

