/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.Railcraft;
import mods.railcraft.client.renderer.entity.cart.LocomotiveRenderer;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class DefaultLocomotiveRenderer
extends LocomotiveRenderer<Locomotive> {
    protected final String modelTag;
    private final EntityModel<? super Locomotive> model;
    private final EntityModel<? super Locomotive> snowLayer;
    private final ResourceLocation[] textures;
    private final float[][] color = new float[3][];
    private float emblemSize = 0.15f;
    private float emblemOffsetX = 0.47f;
    private float emblemOffsetY = -0.17f;
    private float emblemOffsetZ = -0.515f;

    public DefaultLocomotiveRenderer(EntityRendererProvider.Context context, String modelTag, EntityModel<? super Locomotive> model, EntityModel<? super Locomotive> snowLayer) {
        this(context, modelTag, model, snowLayer, new ResourceLocation[]{Railcraft.rl("textures/entity/locomotive/" + modelTag + "/primary.png"), Railcraft.rl("textures/entity/locomotive/" + modelTag + "/secondary.png"), Railcraft.rl("textures/entity/locomotive/" + modelTag + "/nocolor.png"), Railcraft.rl("textures/entity/locomotive/" + modelTag + "/snow.png")});
    }

    public DefaultLocomotiveRenderer(EntityRendererProvider.Context context, String modelTag, EntityModel<? super Locomotive> model, EntityModel<? super Locomotive> snowLayer, ResourceLocation[] textures) {
        super(context);
        this.modelTag = modelTag;
        this.model = model;
        this.snowLayer = snowLayer;
        this.textures = textures;
        this.color[2] = new float[]{1.0f, 1.0f, 1.0f};
    }

    public void setEmblemPosition(float size, float offsetX, float offsetY, float offsetZ) {
        this.emblemSize = size;
        this.emblemOffsetX = offsetX;
        this.emblemOffsetY = offsetY;
        this.emblemOffsetZ = offsetZ;
    }

    @Override
    public void renderBody(Locomotive cart, float time, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int packedLight, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.color[0] = this.getPrimaryColor(cart);
        this.color[1] = this.getSecondaryColor(cart);
        for (int pass = 0; pass < 3; ++pass) {
            float[] color = this.color[pass];
            this.model.m_6973_((Entity)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(this.model.m_103119_(this.textures[pass]));
            this.model.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, color[0], color[1], color[2], alpha);
        }
        if (Seasons.isPolarExpress((AbstractMinecart)cart)) {
            this.snowLayer.m_6973_((Entity)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(this.snowLayer.m_103119_(this.textures[3]));
            this.snowLayer.m_7695_(poseStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.getEmblemTexture(cart).ifPresent(emblemTexture -> {
            VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)emblemTexture));
            vertexBuilder.m_5483_((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY - this.emblemSize), (double)this.emblemOffsetZ).m_7421_(0.0f, 0.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)this.emblemOffsetZ).m_7421_(0.0f, 1.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)this.emblemOffsetZ).m_7421_(1.0f, 1.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + -this.emblemSize), (double)this.emblemOffsetZ).m_7421_(1.0f, 0.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + -this.emblemSize), (double)(-this.emblemOffsetZ)).m_7421_(0.0f, 0.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX + this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)(-this.emblemOffsetZ)).m_7421_(0.0f, 1.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY + this.emblemSize), (double)(-this.emblemOffsetZ)).m_7421_(1.0f, 1.0f).m_5752_();
            vertexBuilder.m_5483_((double)(this.emblemOffsetX - this.emblemSize), (double)(this.emblemOffsetY - this.emblemSize), (double)(-this.emblemOffsetZ)).m_7421_(1.0f, 0.0f).m_5752_();
        });
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(Locomotive loco) {
        throw new IllegalStateException();
    }
}

