/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.RenderUtil;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CuboidModelRenderer {
    private static final int[] combinedARGB = new int[Direction.values().length];
    private static final Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);

    private CuboidModelRenderer() {
    }

    public static void render(CuboidModel model, PoseStack matrix, VertexConsumer buffer, int argb, FaceDisplay faceDisplay, boolean fakeDisableDiffuse) {
        Arrays.fill(combinedARGB, argb);
        CuboidModelRenderer.render(model, matrix, buffer, combinedARGB, faceDisplay, fakeDisableDiffuse);
    }

    public static void render(CuboidModel model, PoseStack matrix, VertexConsumer buffer, int[] colors, FaceDisplay faceDisplay, boolean fakeDisableDiffuse) {
        float xShift = Mth.m_14143_((float)model.getMinX());
        float yShift = Mth.m_14143_((float)model.getMinY());
        float zShift = Mth.m_14143_((float)model.getMinZ());
        matrix.m_85836_();
        matrix.m_252880_(xShift, yShift, zShift);
        float minX = model.getMinX() - xShift;
        float minY = model.getMinY() - yShift;
        float minZ = model.getMinZ() - zShift;
        float maxX = model.getMaxX() - xShift;
        float maxY = model.getMaxY() - yShift;
        float maxZ = model.getMaxZ() - zShift;
        int xDelta = CuboidModelRenderer.calculateDelta(minX, maxX);
        int yDelta = CuboidModelRenderer.calculateDelta(minY, maxY);
        int zDelta = CuboidModelRenderer.calculateDelta(minZ, maxZ);
        float[] xBounds = CuboidModelRenderer.getBlockBounds(xDelta, minX, maxX);
        float[] yBounds = CuboidModelRenderer.getBlockBounds(yDelta, minY, maxY);
        float[] zBounds = CuboidModelRenderer.getBlockBounds(zDelta, minZ, maxZ);
        PoseStack.Pose lastMatrix = matrix.m_85850_();
        Matrix4f matrix4f = lastMatrix.m_252922_();
        Matrix3f normalMatrix = lastMatrix.m_252943_();
        Vector3f normal = fakeDisableDiffuse ? NORMAL : YP;
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        for (int y = 0; y <= yDelta; ++y) {
            CuboidModel.Face upSprite = y == yDelta ? model.get(Direction.UP) : null;
            CuboidModel.Face downSprite = y == 0 ? model.get(Direction.DOWN) : null;
            from.y = yBounds[y];
            to.y = yBounds[y + 1];
            for (int z = 0; z <= zDelta; ++z) {
                CuboidModel.Face northSprite = z == 0 ? model.get(Direction.NORTH) : null;
                CuboidModel.Face southSprite = z == zDelta ? model.get(Direction.SOUTH) : null;
                from.z = zBounds[z];
                to.z = zBounds[z + 1];
                for (int x = 0; x <= xDelta; ++x) {
                    CuboidModel.Face westSprite = x == 0 ? model.get(Direction.WEST) : null;
                    CuboidModel.Face eastSprite = x == xDelta ? model.get(Direction.EAST) : null;
                    from.x = xBounds[x];
                    to.x = xBounds[x + 1];
                    CuboidModelRenderer.putTexturedQuad(buffer, matrix4f, normalMatrix, westSprite, from, to, Direction.WEST, colors, faceDisplay, normal);
                    CuboidModelRenderer.putTexturedQuad(buffer, matrix4f, normalMatrix, eastSprite, from, to, Direction.EAST, colors, faceDisplay, normal);
                    CuboidModelRenderer.putTexturedQuad(buffer, matrix4f, normalMatrix, northSprite, from, to, Direction.NORTH, colors, faceDisplay, normal);
                    CuboidModelRenderer.putTexturedQuad(buffer, matrix4f, normalMatrix, southSprite, from, to, Direction.SOUTH, colors, faceDisplay, normal);
                    CuboidModelRenderer.putTexturedQuad(buffer, matrix4f, normalMatrix, upSprite, from, to, Direction.UP, colors, faceDisplay, normal);
                    CuboidModelRenderer.putTexturedQuad(buffer, matrix4f, normalMatrix, downSprite, from, to, Direction.DOWN, colors, faceDisplay, normal);
                }
            }
        }
        matrix.m_85849_();
    }

    private static float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    private static int calculateDelta(float min, float max) {
        int delta = (int)(max - (float)((int)min));
        if ((double)max % 1.0 == 0.0) {
            --delta;
        }
        return delta;
    }

    private static void putTexturedQuad(VertexConsumer buffer, Matrix4f matrix, Matrix3f normalMatrix, @Nullable CuboidModel.Face spriteInfo, Vector3f from, Vector3f to, Direction face, int[] colors, FaceDisplay faceDisplay, Vector3f normal) {
        float v1;
        float u2;
        float u1;
        if (spriteInfo == null) {
            return;
        }
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        float v2 = switch (face.m_122434_()) {
            default -> {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                yield z1;
            }
            case Direction.Axis.Z -> {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                yield y2;
            }
            case Direction.Axis.X -> {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                yield y2;
            }
        };
        boolean bigger = u1 > u2;
        u1 %= 1.0f;
        u2 %= 1.0f;
        if (bigger) {
            if (u1 == 0.0f) {
                u1 = 1.0f;
            }
        } else if (u2 == 0.0f) {
            u2 = 1.0f;
        }
        bigger = v1 > v2;
        v1 %= 1.0f;
        v2 %= 1.0f;
        if (bigger) {
            if (v1 == 0.0f) {
                v1 = 1.0f;
            }
        } else if (v2 == 0.0f) {
            v2 = 1.0f;
        }
        float temp = v1;
        v1 = 1.0f - v2;
        v2 = 1.0f - temp;
        float minU = spriteInfo.getSprite().m_118367_((double)(u1 * (float)spriteInfo.getSize()));
        float maxU = spriteInfo.getSprite().m_118367_((double)(u2 * (float)spriteInfo.getSize()));
        float minV = spriteInfo.getSprite().m_118393_((double)(v1 * (float)spriteInfo.getSize()));
        float maxV = spriteInfo.getSprite().m_118393_((double)(v2 * (float)spriteInfo.getSize()));
        int argb = colors[face.ordinal()];
        float red = RenderUtil.getRed(argb);
        float green = RenderUtil.getGreen(argb);
        float blue = RenderUtil.getBlue(argb);
        float alpha = RenderUtil.getAlpha(argb);
        switch (face) {
            case DOWN: {
                CuboidModelRenderer.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, spriteInfo.getPackedLight(), spriteInfo.getPackedOverlay(), faceDisplay, normal, x1, y1, z2, x1, y1, z1, x2, y1, z1, x2, y1, z2);
                break;
            }
            case UP: {
                CuboidModelRenderer.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, spriteInfo.getPackedLight(), spriteInfo.getPackedOverlay(), faceDisplay, normal, x1, y2, z1, x1, y2, z2, x2, y2, z2, x2, y2, z1);
                break;
            }
            case NORTH: {
                CuboidModelRenderer.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, spriteInfo.getPackedLight(), spriteInfo.getPackedOverlay(), faceDisplay, normal, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1);
                break;
            }
            case SOUTH: {
                CuboidModelRenderer.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, spriteInfo.getPackedLight(), spriteInfo.getPackedOverlay(), faceDisplay, normal, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2);
                break;
            }
            case WEST: {
                CuboidModelRenderer.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, spriteInfo.getPackedLight(), spriteInfo.getPackedOverlay(), faceDisplay, normal, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1);
                break;
            }
            case EAST: {
                CuboidModelRenderer.drawFace(buffer, matrix, normalMatrix, red, green, blue, alpha, minU, maxU, minV, maxV, spriteInfo.getPackedLight(), spriteInfo.getPackedOverlay(), faceDisplay, normal, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2);
            }
        }
    }

    private static void drawFace(VertexConsumer buffer, Matrix4f matrix, Matrix3f normalMatrix, float red, float green, float blue, float alpha, float minU, float maxU, float minV, float maxV, int light, int overlay, FaceDisplay faceDisplay, Vector3f normal, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        if (faceDisplay.front) {
            buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_5752_();
            buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_5752_();
            buffer.m_252986_(matrix, x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_5752_();
            buffer.m_252986_(matrix, x4, y4, z4).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, normal.x(), normal.y(), normal.z()).m_5752_();
        }
        if (faceDisplay.back) {
            buffer.m_252986_(matrix, x4, y4, z4).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(overlay).m_85969_(light).m_252939_(normalMatrix, 0.0f, -1.0f, 0.0f).m_5752_();
        }
    }

    static {
        NORMAL.normalize();
    }

    public static enum FaceDisplay {
        FRONT(true, false),
        BACK(false, true),
        BOTH(true, true);

        private final boolean front;
        private final boolean back;

        private FaceDisplay(boolean front, boolean back) {
            this.front = front;
            this.back = back;
        }
    }
}

