/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.play;

import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.function.Supplier;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.network.NetworkEvent;

public record SetSwitchTrackMotorAttributesMessage(BlockPos blockPos, EnumSet<SignalAspect> actionSignalAspects, boolean redstoneTriggered, LockableSwitchTrackActuatorBlockEntity.Lock lock) {
    public void encode(FriendlyByteBuf out) {
        out.m_130064_(this.blockPos);
        out.m_245616_(this.actionSignalAspects, SignalAspect.class);
        out.writeBoolean(this.redstoneTriggered);
        out.m_130068_((Enum)this.lock);
    }

    public static SetSwitchTrackMotorAttributesMessage decode(FriendlyByteBuf in) {
        BlockPos blockPos = in.m_130135_();
        EnumSet actionSignalAspects = in.m_247336_(SignalAspect.class);
        boolean redstoneTriggered = in.readBoolean();
        LockableSwitchTrackActuatorBlockEntity.Lock lock = (LockableSwitchTrackActuatorBlockEntity.Lock)in.m_130066_(LockableSwitchTrackActuatorBlockEntity.Lock.class);
        return new SetSwitchTrackMotorAttributesMessage(blockPos, actionSignalAspects, redstoneTriggered, lock);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        Level level = player.m_9236_();
        GameProfile senderProfile = player.m_36316_();
        level.m_141902_(this.blockPos, (BlockEntityType)RailcraftBlockEntityTypes.SWITCH_TRACK_MOTOR.get()).filter(switchTrack -> switchTrack.canAccess(senderProfile)).ifPresent(switchTrack -> {
            switchTrack.getActionSignalAspects().clear();
            switchTrack.getActionSignalAspects().addAll(this.actionSignalAspects);
            switchTrack.setRedstoneTriggered(this.redstoneTriggered);
            switchTrack.setLock(this.lock.equals(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED) ? null : senderProfile);
            switchTrack.syncToClient();
            switchTrack.m_6596_();
        });
        return true;
    }
}

