/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static <T> Optional<T> getFromRegistry(JsonObject object, String memberName, IForgeRegistry<T> registry) {
        return JsonUtil.getAsString(object, memberName).map(ResourceLocation::m_135820_).map(arg_0 -> registry.getValue(arg_0));
    }

    public static Optional<String> getAsString(JsonObject object, String memberName) {
        return JsonUtil.get(object, memberName).map(JsonElement::getAsString);
    }

    public static Optional<Boolean> getAsBoolean(JsonObject object, String memberName) {
        return JsonUtil.get(object, memberName).map(JsonElement::getAsBoolean);
    }

    public static Optional<JsonObject> getAsJsonObject(JsonObject object, String memberName) {
        return JsonUtil.get(object, memberName).map(JsonElement::getAsJsonObject);
    }

    public static Optional<JsonElement> get(JsonObject object, String memberName) {
        return object.has(memberName) ? Optional.of(object.get(memberName)) : Optional.empty();
    }
}

