/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mods.railcraft.Railcraft;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Side;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.event.CartLinkEvent;
import mods.railcraft.world.entity.vehicle.LaunchState;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.TrainImpl;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.behaivor.HighSpeedTrackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.slf4j.Logger;

public class RollingStockImpl
implements RollingStock,
INBTSerializable<CompoundTag> {
    public static final ResourceLocation KEY = Railcraft.rl("rolling_stock");
    private static final double LINK_DRAG = 0.95;
    private static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.7f;
    private static final float HS_STIFFNESS = 0.7f;
    private static final float DAMPING = 0.4f;
    private static final float HS_DAMPING = 0.3f;
    private static final float FORCE_LIMITER = 6.0f;
    private static final int DIMENSION_TIMEOUT_TICKS = 200;
    private static final Logger logger = LogUtils.getLogger();
    private final AbstractMinecart minecart;
    @Nullable
    private RollingStock frontLink;
    @Nullable
    private RollingStock backLink;
    @Nullable
    private UUID unresolvedBackLink;
    @Nullable
    private UUID unresolvedFrontLink;
    private boolean backAutoLinkEnabled;
    private boolean frontAutoLinkEnabled;
    private LaunchState launchState = LaunchState.LANDED;
    private int elevatorRemainingTicks;
    private int preventMountRemainingTicks;
    private int derailedRemainingTicks;
    private boolean explosionPending;
    private boolean highSpeed;
    private int primaryLinkTimeoutTicks;
    private int secondaryLinkTimeoutTicks;
    @Nullable
    private TrainImpl train;

    public RollingStockImpl(AbstractMinecart minecart) {
        this.minecart = minecart;
    }

    @Override
    public boolean hasLink(Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.FRONT -> {
                if (this.frontLink != null) {
                    yield true;
                }
                yield false;
            }
            case Side.BACK -> this.backLink != null;
        };
    }

    @Override
    public Optional<RollingStock> linkAt(Side side) {
        this.resolveLinks();
        return Optional.ofNullable(switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.FRONT -> this.frontLink;
            case Side.BACK -> this.backLink;
        });
    }

    private void setLink(Side side, @Nullable RollingStock minecart) {
        switch (side) {
            case FRONT: {
                this.frontLink = minecart;
                break;
            }
            case BACK: {
                this.backLink = minecart;
            }
        }
    }

    private void resolveLinks() {
        if (this.unresolvedBackLink != null) {
            this.resolveLink(this.unresolvedBackLink).ifPresent(cart -> {
                this.backLink = cart;
                this.unresolvedBackLink = null;
            });
        }
        if (this.unresolvedFrontLink != null) {
            this.resolveLink(this.unresolvedFrontLink).ifPresent(cart -> {
                this.frontLink = cart;
                this.unresolvedFrontLink = null;
            });
        }
    }

    private Optional<RollingStock> resolveLink(UUID minecartId) {
        Optional optional;
        ServerLevel level = (ServerLevel)this.minecart.m_9236_();
        Entity entity = level.m_8791_(minecartId);
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)entity;
            optional = minecart.getCapability(CAPABILITY).filter(cart -> {
                boolean result = cart.isLinkedWith(this);
                if (!result) {
                    logger.warn("Link mismatch between {} and {} (link was missing on {})", new Object[]{this.minecart, cart.entity(), cart.entity()});
                }
                return result;
            });
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public Optional<Side> sideOf(RollingStock rollingStock) {
        Objects.requireNonNull(rollingStock, "rollingStock cannot be null.");
        if (this.unresolvedBackLink != null && rollingStock.entity().m_20148_().equals(this.unresolvedBackLink)) {
            this.unresolvedBackLink = null;
            this.backLink = rollingStock;
            return Optional.of(Side.BACK);
        }
        if (this.unresolvedFrontLink != null && rollingStock.entity().m_20148_().equals(this.unresolvedFrontLink)) {
            this.unresolvedFrontLink = null;
            this.frontLink = rollingStock;
            return Optional.of(Side.FRONT);
        }
        if (this.backLink == rollingStock) {
            return Optional.of(Side.BACK);
        }
        if (this.frontLink == rollingStock) {
            return Optional.of(Side.FRONT);
        }
        return Optional.empty();
    }

    @Override
    public boolean link(RollingStock rollingStock) {
        float maxDistance = this.getLinkageDistanceSq(rollingStock);
        if (this == rollingStock || this.isSameTrainAs(rollingStock) || !this.isEnd() || !rollingStock.isEnd() || this.entity().m_20280_((Entity)rollingStock.entity()) > (double)maxDistance) {
            return false;
        }
        if (!this.isLinkableWith(rollingStock) || !rollingStock.isLinkableWith(this)) {
            return false;
        }
        Train train = this.train();
        rollingStock.train().copyTo(train);
        Side linkSide = null;
        for (Side side : Side.values()) {
            if (this.disabledSide().filter(side::equals).isPresent()) continue;
            if (rollingStock.disabledSide().map(Side::opposite).filter(side::equals).isPresent()) continue;
            if (this.hasLink(side) && rollingStock.hasLink(side) && !this.swapLinks(side) && !rollingStock.swapLinks(side)) {
                return false;
            }
            linkSide = side;
        }
        if (linkSide == null) {
            return false;
        }
        this.completeLink(rollingStock, linkSide);
        rollingStock.completeLink(this, linkSide.opposite());
        train.copyTo(this.train());
        MinecraftForge.EVENT_BUS.post((Event)new CartLinkEvent.Link(this, rollingStock));
        return true;
    }

    @Override
    public void completeLink(RollingStock rollingStock, Side side) {
        this.setLink(side, rollingStock);
        this.setAutoLinkEnabled(side, false);
        AbstractMinecart abstractMinecart = this.minecart;
        if (abstractMinecart instanceof Linkable) {
            Linkable handler = (Linkable)abstractMinecart;
            handler.linked(rollingStock);
        }
    }

    @Override
    public void removeLink(Side side) {
        this.linkAt(side).ifPresent(linked -> {
            this.setLink(side, null);
            AbstractMinecart patt7146$temp = this.minecart;
            if (patt7146$temp instanceof Linkable) {
                Linkable handler = (Linkable)patt7146$temp;
                handler.unlinked((RollingStock)linked);
            }
        });
    }

    @Override
    public boolean unlink(Side side) {
        RollingStock linkedCart = this.linkAt(side).orElse(null);
        if (linkedCart == null) {
            return false;
        }
        linkedCart.sideOf(this).ifPresent(linkedCart::removeLink);
        this.removeLink(side);
        MinecraftForge.EVENT_BUS.post((Event)new CartLinkEvent.Unlink(this, linkedCart));
        return true;
    }

    @Override
    public boolean swapLinks(Side side) {
        RollingStock next;
        switch (side) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FRONT: {
                RollingStock rollingStock = this.frontLink;
                break;
            }
            case BACK: {
                RollingStock rollingStock = next = this.backLink;
            }
        }
        if (next != null && !next.swapLinks(side)) {
            return false;
        }
        if (this.disabledSide().isPresent()) {
            return false;
        }
        RollingStock oldFront = this.frontLink;
        this.frontLink = this.backLink;
        this.backLink = oldFront;
        return true;
    }

    @Override
    public boolean isAutoLinkEnabled(Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.BACK -> this.backAutoLinkEnabled;
            case Side.FRONT -> this.frontAutoLinkEnabled;
        };
    }

    @Override
    public boolean setAutoLinkEnabled(Side side, boolean enabled) {
        if (enabled) {
            if (this.disabledSide().filter(side::equals).isPresent()) {
                return false;
            }
        }
        switch (side) {
            case BACK: {
                this.backAutoLinkEnabled = enabled;
                break;
            }
            case FRONT: {
                this.frontAutoLinkEnabled = enabled;
            }
        }
        return true;
    }

    @Override
    public boolean isLaunched() {
        return this.launchState == LaunchState.LAUNCHED;
    }

    @Override
    public void launch() {
        this.launchState = LaunchState.LAUNCHING;
        this.minecart.setCanUseRail(false);
    }

    @Override
    public int getElevatorRemainingTicks() {
        return this.elevatorRemainingTicks;
    }

    @Override
    public void setElevatorRemainingTicks(int elevatorRemainingTicks) {
        this.elevatorRemainingTicks = elevatorRemainingTicks;
    }

    @Override
    public boolean isMountable() {
        return this.preventMountRemainingTicks <= 0;
    }

    @Override
    public void setPreventMountRemainingTicks(int preventMountRemainingTicks) {
        this.preventMountRemainingTicks = preventMountRemainingTicks;
    }

    @Override
    public boolean isDerailed() {
        return this.derailedRemainingTicks > 0;
    }

    @Override
    public void setDerailedRemainingTicks(int derailedRemainingTicks) {
        this.derailedRemainingTicks = derailedRemainingTicks;
    }

    @Override
    public void primeExplosion() {
        this.explosionPending = true;
    }

    @Override
    public boolean isHighSpeed() {
        return this.highSpeed;
    }

    @Override
    public void checkHighSpeed(BlockPos blockPos) {
        Vec3 currentMotion = this.minecart.m_20184_();
        if (this.highSpeed) {
            HighSpeedTrackUtil.checkSafetyAndExplode(this.level(), blockPos, this.minecart);
            return;
        }
        if (!HighSpeedTrackUtil.isTrackSafeForHighSpeed(this.level(), blockPos, this.minecart)) {
            this.limitSpeed();
            return;
        }
        if (Math.abs(currentMotion.m_7096_()) > (double)0.499f) {
            double motionX = Math.copySign((double)0.499f, currentMotion.m_7096_());
            this.minecart.m_20334_(motionX, currentMotion.m_7098_(), currentMotion.m_7094_());
            this.highSpeed = true;
        }
        if (Math.abs(currentMotion.m_7094_()) > (double)0.499f) {
            double motionZ = Math.copySign((double)0.499f, currentMotion.m_7094_());
            this.minecart.m_20334_(currentMotion.m_7096_(), currentMotion.m_7098_(), motionZ);
            this.highSpeed = true;
        }
    }

    private void limitSpeed() {
        Vec3 motion = this.minecart.m_20184_();
        double motionX = Math.copySign(Math.min((double)0.499f, Math.abs(motion.m_7096_())), motion.m_7096_());
        double motionZ = Math.copySign(Math.min((double)0.499f, Math.abs(motion.m_7094_())), motion.m_7094_());
        this.minecart.m_20334_(motionX, motion.m_7098_(), motionZ);
    }

    @Override
    public AbstractMinecart entity() {
        return this.minecart;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.train != null) {
            tag.m_128365_("train", (Tag)this.train.toTag());
        }
        if (this.unresolvedBackLink != null) {
            tag.m_128362_("backLink", this.unresolvedBackLink);
        } else if (this.backLink != null) {
            tag.m_128362_("backLink", this.backLink.entity().m_20148_());
        }
        if (this.unresolvedFrontLink != null) {
            tag.m_128362_("frontLink", this.unresolvedFrontLink);
        } else if (this.frontLink != null) {
            tag.m_128362_("frontLink", this.frontLink.entity().m_20148_());
        }
        tag.m_128379_("backAutoLinkEnabled", this.backAutoLinkEnabled);
        tag.m_128379_("frontAutoLinkEnabled", this.frontAutoLinkEnabled);
        tag.m_128359_("launchState", this.launchState.getName());
        tag.m_128405_("elevatorRemainingTicks", this.elevatorRemainingTicks);
        tag.m_128405_("preventMountRemainingTicks", this.preventMountRemainingTicks);
        tag.m_128405_("derailedRemainingTicks", this.derailedRemainingTicks);
        tag.m_128379_("explosionPending", this.explosionPending);
        tag.m_128379_("highSpeed", this.highSpeed);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.train = tag.m_128425_("train", 10) ? TrainImpl.fromTag(tag.m_128469_("train"), this) : null;
        this.unresolvedBackLink = tag.m_128403_("backLink") ? tag.m_128342_("backLink") : null;
        this.unresolvedFrontLink = tag.m_128403_("frontLink") ? tag.m_128342_("frontLink") : null;
        this.backAutoLinkEnabled = tag.m_128471_("backAutoLinkEnabled");
        this.frontAutoLinkEnabled = tag.m_128471_("frontAutoLinkEnabled");
        this.launchState = LaunchState.getByName(tag.m_128461_("launchState")).orElse(LaunchState.LANDED);
        this.elevatorRemainingTicks = tag.m_128451_("elevatorRemainingTicks");
        this.preventMountRemainingTicks = tag.m_128451_("preventMountRemainingTicks");
        this.derailedRemainingTicks = tag.m_128451_("derailedRemainingTicks");
        this.explosionPending = tag.m_128471_("explosionPending");
        this.highSpeed = tag.m_128471_("highSpeed");
    }

    @Override
    public boolean isFront() {
        this.resolveLinks();
        return this.frontLink == null;
    }

    private boolean validateTrainOwnership() {
        boolean front = this.isFront();
        if (!front && this.train != null) {
            this.train = null;
        }
        if (front && this.train == null) {
            this.train = TrainImpl.create(this);
        }
        return front;
    }

    @Override
    public Train train() {
        return this.validateTrainOwnership() ? this.train : this.frontLink.train();
    }

    @Override
    public void removed(Entity.RemovalReason reason) {
        if (reason.m_146965_()) {
            this.forceChunk(false);
            this.unlinkAll();
        } else {
            this.forceChunk(this.train().size() > 1);
        }
    }

    private void forceChunk(boolean add) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos chunk = this.minecart.m_146902_();
            ForgeChunkManager.forceChunk((ServerLevel)level2, (String)"railcraft", (UUID)this.minecart.m_20148_(), (int)chunk.f_45578_, (int)chunk.f_45579_, (boolean)add, (boolean)false);
        }
    }

    @Override
    public void tick() {
        float cutoff;
        float distance;
        if (this.level().m_5776_()) {
            return;
        }
        this.adjustCart();
        if (this.preventMountRemainingTicks > 0) {
            --this.preventMountRemainingTicks;
        }
        if (this.elevatorRemainingTicks < 20) {
            this.minecart.m_20242_(false);
        }
        if (this.elevatorRemainingTicks > 0) {
            --this.elevatorRemainingTicks;
        }
        if (this.derailedRemainingTicks > 0) {
            --this.derailedRemainingTicks;
        }
        if (this.explosionPending) {
            this.explosionPending = false;
            MinecartUtil.explodeCart(this.entity());
        }
        if (this.highSpeed) {
            if (MinecartUtil.cartVelocityIsLessThan(this.entity(), 0.5f)) {
                this.highSpeed = false;
            } else if (this.launchState == LaunchState.LANDED) {
                HighSpeedTrackUtil.checkSafetyAndExplode(this.level(), this.minecart.m_20183_(), this.entity());
            }
        }
        if ((distance = Mth.m_14118_((float)this.minecart.m_146908_(), (float)this.minecart.f_19859_)) < -(cutoff = 120.0f) || distance >= cutoff) {
            this.minecart.m_146922_(this.minecart.m_146908_() + 180.0f);
            this.minecart.f_38068_ = !this.minecart.f_38068_;
            this.minecart.m_146922_(this.minecart.m_146908_() % 360.0f);
        }
        if (BaseRailBlock.m_49364_((Level)this.level(), (BlockPos)this.minecart.m_20183_())) {
            this.minecart.f_19789_ = 0.0f;
            if (this.minecart.m_20160_()) {
                this.minecart.m_20197_().forEach(p -> {
                    p.f_19789_ = 0.0f;
                });
            }
            if (this.launchState == LaunchState.LAUNCHED) {
                this.land();
            }
        } else if (this.launchState == LaunchState.LAUNCHING) {
            this.launchState = LaunchState.LAUNCHED;
            this.minecart.setCanUseRail(true);
        } else if (this.launchState == LaunchState.LAUNCHED && this.minecart.m_20096_()) {
            this.land();
        }
        Vec3 motion = this.minecart.m_20184_();
        double motionX = Math.copySign(Math.min(Math.abs(motion.m_7096_()), 9.5), motion.m_7096_());
        double motionY = Math.copySign(Math.min(Math.abs(motion.m_7098_()), 9.5), motion.m_7098_());
        double motionZ = Math.copySign(Math.min(Math.abs(motion.m_7094_()), 9.5), motion.m_7094_());
        this.minecart.m_20334_(motionX, motionY, motionZ);
    }

    private void adjustCart() {
        boolean linked;
        if (this.isLaunched() || this.isOnElevator()) {
            return;
        }
        boolean linkedA = this.maintainLink(Side.BACK);
        boolean linkedB = this.maintainLink(Side.FRONT);
        boolean bl = linked = linkedA || linkedB;
        if (linked && !this.isHighSpeed()) {
            this.minecart.m_20256_(this.minecart.m_20184_().m_82542_(0.95, 1.0, 0.95));
        }
        if (this.validateTrainOwnership()) {
            this.train.refreshMaxSpeed();
        }
    }

    public boolean maintainLink(Side linkSide) {
        RollingStock linkedStock = this.linkAt(linkSide).orElse(null);
        if (linkedStock == null) {
            return false;
        }
        if (linkedStock.isLaunched() || linkedStock.isOnElevator()) {
            return false;
        }
        AbstractMinecart linkedEntity = linkedStock.entity();
        boolean sameDimension = this.level().m_46472_().equals(linkedEntity.m_9236_().m_46472_());
        boolean unlink = false;
        switch (linkSide) {
            case BACK: {
                if (sameDimension) {
                    this.primaryLinkTimeoutTicks = 0;
                    break;
                }
                if (++this.primaryLinkTimeoutTicks > 200) {
                    unlink = true;
                    break;
                }
                return true;
            }
            case FRONT: {
                if (sameDimension) {
                    this.secondaryLinkTimeoutTicks = 0;
                    break;
                }
                if (++this.secondaryLinkTimeoutTicks > 200) {
                    unlink = true;
                    break;
                }
                return true;
            }
        }
        if (unlink) {
            logger.debug("Linked rolling stock in separate dimension, unlinking: {}", (Object)linkedEntity);
            this.unlink(linkSide);
            return false;
        }
        double dist = this.minecart.m_20270_((Entity)linkedEntity);
        if (dist > 8.0) {
            logger.debug("Max distance exceeded, unlinking: {}", (Object)linkedEntity);
            this.unlink(linkSide);
            return false;
        }
        boolean adj1 = this.canCartBeAdjustedBy(linkedStock);
        boolean adj2 = linkedStock.canCartBeAdjustedBy(this);
        Vector2d cart1Pos = new Vector2d(this.minecart.m_20185_(), this.minecart.m_20189_());
        Vector2d cart2Pos = new Vector2d(linkedEntity.m_20185_(), linkedEntity.m_20189_());
        Vector2d sub = cart2Pos.sub((Vector2dc)cart1Pos);
        Vector2d unit = sub.equals(0.0, 0.0) ? sub : sub.normalize();
        float optDist = this.getOptimalDistance(linkedStock);
        double stretch = dist - (double)optDist;
        boolean highSpeed = this.isHighSpeed();
        float stiffness = highSpeed ? 0.7f : 0.7f;
        double springX = (double)stiffness * stretch * unit.x();
        double springZ = (double)stiffness * stretch * unit.y();
        springX = RollingStockImpl.limitForce(springX);
        springZ = RollingStockImpl.limitForce(springZ);
        if (adj1) {
            this.minecart.m_20256_(this.minecart.m_20184_().m_82520_(springX, 0.0, springZ));
        }
        if (adj2) {
            linkedEntity.m_20256_(linkedEntity.m_20184_().m_82492_(springX, 0.0, springZ));
        }
        Vector2d cart1Vel = new Vector2d(this.minecart.m_20184_().m_7096_(), this.minecart.m_20184_().m_7094_());
        Vector2d cart2Vel = new Vector2d(linkedEntity.m_20184_().m_7096_(), linkedEntity.m_20184_().m_7094_());
        double dot = cart2Vel.sub((Vector2dc)cart1Vel).dot((Vector2dc)unit);
        float damping = highSpeed ? 0.3f : 0.4f;
        double dampX = (double)damping * dot * unit.x();
        double dampZ = (double)damping * dot * unit.y();
        dampX = RollingStockImpl.limitForce(dampX);
        dampZ = RollingStockImpl.limitForce(dampZ);
        if (adj1) {
            this.minecart.m_20256_(this.minecart.m_20184_().m_82520_(dampX, 0.0, dampZ));
        }
        if (adj2) {
            linkedEntity.m_20256_(linkedEntity.m_20184_().m_82492_(dampX, 0.0, dampZ));
        }
        return true;
    }

    private void land() {
        this.launchState = LaunchState.LANDED;
        this.minecart.setMaxSpeedAirLateral(0.4f);
        this.minecart.setMaxSpeedAirVertical(-1.0f);
        this.minecart.setDragAir((double)0.95f);
    }

    private float getOptimalDistance(RollingStock rollingStock) {
        Linkable handler;
        float dist = 0.0f;
        AbstractMinecart abstractMinecart = this.minecart;
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getOptimalDistance(rollingStock);
        } else {
            dist += 0.78f;
        }
        abstractMinecart = rollingStock.entity();
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getOptimalDistance(this);
        } else {
            dist += 0.78f;
        }
        return dist;
    }

    private static double limitForce(double force) {
        return Math.copySign(Math.min(Math.abs(force), 6.0), force);
    }

    private float getLinkageDistanceSq(RollingStock rollingStock) {
        Linkable handler;
        float dist = 0.0f;
        AbstractMinecart abstractMinecart = this.minecart;
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getLinkageDistance(rollingStock);
        } else {
            dist += 1.25f;
        }
        abstractMinecart = rollingStock.entity();
        if (abstractMinecart instanceof Linkable) {
            handler = (Linkable)abstractMinecart;
            dist += handler.getLinkageDistance(this);
        } else {
            dist += 1.25f;
        }
        return dist * dist;
    }

    @Override
    public Optional<GameProfile> owner() {
        Optional<GameProfile> optional;
        AbstractMinecart abstractMinecart = this.entity();
        if (abstractMinecart instanceof Locomotive) {
            Locomotive loco = (Locomotive)abstractMinecart;
            optional = loco.getOwner();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

