/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSignalBoxBlockEntity
extends RailcraftBlockEntity {
    public AbstractSignalBoxBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public void onLoad() {
        super.onLoad();
        this.updateNeighborSignalBoxes(false);
    }

    @Override
    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
    }

    public void neighborChanged() {
    }

    public abstract SignalAspect getSignalAspect(Direction var1);

    public void blockRemoved() {
        this.updateNeighborSignalBoxes(true);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_151543_(this.m_58899_());
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.updateNeighborSignalBoxes(false);
    }

    protected void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighborSignalBox, Direction neighborDirection, boolean removed) {
    }

    public final void updateNeighborSignalBoxes(boolean removed) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (!(blockEntity instanceof AbstractSignalBoxBlockEntity)) continue;
            AbstractSignalBoxBlockEntity box = (AbstractSignalBoxBlockEntity)blockEntity;
            box.neighborSignalBoxChanged(this, direction, removed);
        }
    }

    public int getRedstoneSignal(Direction direction) {
        return 0;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.blockPos().m_7918_(-1, 0, -1), this.blockPos().m_7918_(2, 2, 2));
    }
}

