/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.steamboiler;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.level.block.steamboiler.FireboxBlock;
import mods.railcraft.world.level.block.steamboiler.SteamBoilerTankBlock;
import mods.railcraft.world.module.SteamBoilerModule;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SteamBoilerBlockEntity
extends MultiblockBlockEntity<SteamBoilerBlockEntity, Metadata> {
    public static final int TRANSFER_RATE = 1000;
    public static final int TICKS_LOW = 16;
    public static final int TICKS_HIGH = 8;
    public static final int STEAM_LOW = 16;
    public static final int STEAM_HIGH = 32;
    public static final float HEAT_LOW = 500.0f;
    public static final float HEAT_HIGH = 1000.0f;
    private static final List<MultiblockPattern<Metadata>> PATTERNS = (List)Util.m_137537_(() -> {
        ImmutableList.Builder patterns = ImmutableList.builder();
        patterns.addAll(SteamBoilerBlockEntity.buildPatterns(BlockPredicate.of(RailcraftBlocks.SOLID_FUELED_FIREBOX)));
        patterns.addAll(SteamBoilerBlockEntity.buildPatterns(BlockPredicate.of(RailcraftBlocks.FLUID_FUELED_FIREBOX)));
        return patterns.build();
    });
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();

    public SteamBoilerBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.STEAM_BOILER.get(), blockPos, blockState);
    }

    public SteamBoilerBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState, SteamBoilerBlockEntity.class, PATTERNS);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SteamBoilerBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
    }

    @Override
    public InteractionResult use(ServerPlayer player, InteractionHand hand) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getModule(SteamBoilerModule.class).get().getTankManager()) ? InteractionResult.CONSUME : super.use(player, hand);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return LazyOptional.empty();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        throw new UnsupportedOperationException("Not a master block.");
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return element.marker() != 'O';
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<SteamBoilerBlockEntity> membership) {
        if (membership == null) {
            this.fluidHandler = LazyOptional.empty();
            this.itemHandler = LazyOptional.empty();
            this.getModule(SteamBoilerModule.class).ifPresent(module -> Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Container)module));
        } else {
            SteamBoilerModule module2 = membership.master().getModule(SteamBoilerModule.class).get();
            if (membership.master() == this) {
                module2.update((Metadata)this.getCurrentPattern().get().getMetadata());
            }
            this.fluidHandler = module2.getFluidHandler();
            this.itemHandler = module2.getItemHandler();
        }
        if (this.m_58900_().m_60734_() instanceof FireboxBlock && membership == null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(FireboxBlock.LIT, (Comparable)Boolean.valueOf(false)));
        } else if (this.m_58900_().m_60734_() instanceof SteamBoilerTankBlock) {
            if (membership == null) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(SteamBoilerTankBlock.CONNECTION_TYPE, (Comparable)((Object)SteamBoilerTankBlock.ConnectionType.NONE)));
                return;
            }
            BlockPos patternPos = membership.patternElement().relativePos();
            char marker = membership.patternElement().marker();
            MultiblockPattern pattern = membership.master().getCurrentPattern().get();
            boolean north = pattern.getMarkerOrDefault(patternPos.m_122012_(), 'O') == marker;
            boolean south = pattern.getMarkerOrDefault(patternPos.m_122019_(), 'O') == marker;
            boolean east = pattern.getMarkerOrDefault(patternPos.m_122029_(), 'O') == marker;
            boolean west = pattern.getMarkerOrDefault(patternPos.m_122024_(), 'O') == marker;
            SteamBoilerTankBlock.ConnectionType type = null;
            if (!(north || south || east || west)) {
                type = SteamBoilerTankBlock.ConnectionType.NONE;
            } else if (north && south && east && west) {
                type = SteamBoilerTankBlock.ConnectionType.ALL;
            } else if (north && south && east) {
                type = SteamBoilerTankBlock.ConnectionType.NORTH_SOUTH_EAST;
            } else if (south && east && west) {
                type = SteamBoilerTankBlock.ConnectionType.SOUTH_EAST_WEST;
            } else if (north && east && west) {
                type = SteamBoilerTankBlock.ConnectionType.NORTH_EAST_WEST;
            } else if (north && south && west) {
                type = SteamBoilerTankBlock.ConnectionType.NORTH_SOUTH_WEST;
            } else if (north && east) {
                type = SteamBoilerTankBlock.ConnectionType.NORTH_EAST;
            } else if (south && east) {
                type = SteamBoilerTankBlock.ConnectionType.SOUTH_EAST;
            } else if (south && west) {
                type = SteamBoilerTankBlock.ConnectionType.SOUTH_WEST;
            } else if (north && west) {
                type = SteamBoilerTankBlock.ConnectionType.NORTH_WEST;
            }
            if (type == null) {
                throw new IllegalStateException("Something's not right here...");
            }
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(SteamBoilerTankBlock.CONNECTION_TYPE, (Comparable)((Object)type)));
        }
    }

    private static List<MultiblockPattern<Metadata>> buildPatterns(BlockPredicate fireboxPredicate) {
        return List.of(SteamBoilerBlockEntity.buildPattern(3, 4, 2, 8, 1000.0f, 32, BlockPredicate.of(RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(3, 3, 2, 8, 1000.0f, 32, BlockPredicate.of(RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(3, 2, 2, 8, 1000.0f, 32, BlockPredicate.of(RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(2, 3, 1, 8, 1000.0f, 32, BlockPredicate.of(RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(2, 2, 1, 8, 1000.0f, 32, BlockPredicate.of(RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(1, 1, 1, 8, 1000.0f, 32, BlockPredicate.of(RailcraftBlocks.HIGH_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(3, 4, 2, 16, 500.0f, 16, BlockPredicate.of(RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(3, 3, 2, 16, 500.0f, 16, BlockPredicate.of(RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(3, 2, 2, 16, 500.0f, 16, BlockPredicate.of(RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(2, 3, 1, 16, 500.0f, 16, BlockPredicate.of(RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(2, 2, 1, 16, 500.0f, 16, BlockPredicate.of(RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate), SteamBoilerBlockEntity.buildPattern(1, 1, 1, 16, 500.0f, 16, BlockPredicate.of(RailcraftBlocks.LOW_PRESSURE_STEAM_BOILER_TANK), fireboxPredicate));
    }

    private static MultiblockPattern<Metadata> buildPattern(int width, int tankHeight, int offset, int ticks, float heat, int capacity, BlockPredicate tankPredicate, BlockPredicate fireboxPredicate) {
        int i;
        MultiblockPattern.Builder<Metadata> builder = MultiblockPattern.builder(offset, 0, offset).metadata(new Metadata(width * width * tankHeight, ticks, heat, capacity)).predicate('T', tankPredicate).predicate('F', fireboxPredicate).predicate('O', tankPredicate.or(fireboxPredicate).negate());
        ArrayList<Object> layer = new ArrayList<CharList>();
        for (i = 0; i < width + 2; ++i) {
            CharArrayList list = new CharArrayList();
            for (int j = 0; j < width + 2; ++j) {
                list.add('O');
            }
            layer.add((CharList)list);
        }
        builder.layer(layer);
        for (i = 0; i < tankHeight; ++i) {
            layer = new ArrayList();
            for (int j = 0; j < width + 2; ++j) {
                CharArrayList list = new CharArrayList();
                for (int k = 0; k < width + 2; ++k) {
                    list.add((char)(j == 0 || k == 0 || j == width + 1 || k == width + 1 ? 79 : 84));
                }
                layer.add((CharList)list);
            }
            builder.layer(layer);
        }
        layer = new ArrayList();
        for (i = 0; i < width + 2; ++i) {
            CharArrayList list = new CharArrayList();
            for (int j = 0; j < width + 2; ++j) {
                list.add((char)(i == 0 || j == 0 || i == width + 1 || j == width + 1 ? 79 : 70));
            }
            layer.add(list);
        }
        builder.layer(layer);
        return builder.build();
    }

    public record Metadata(int tanks, int ticksPerCycle, float maxTemperature, int steamCapacityPerTank) {
    }
}

