/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.behaivor;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.api.track.TypedTrack;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public final class HighSpeedTrackUtil {
    private static final int LOOK_AHEAD_DIST = 2;
    private static final float SPEED_SLOPE = 0.45f;

    public static double getMaxSpeed(Level level, @Nullable AbstractMinecart cart, BlockPos pos) {
        return TrackUtil.getTrackDirection((BlockGetter)level, pos, cart).m_61745_() ? (double)0.45f : HighSpeedTrackUtil.speedForNextTrack(level, pos, 0, cart);
    }

    public static void checkSafetyAndExplode(Level level, BlockPos pos, AbstractMinecart cart) {
        if (!HighSpeedTrackUtil.isTrackSafeForHighSpeed(level, pos, cart)) {
            MinecartUtil.explodeCart(cart);
        }
    }

    public static boolean isTrackSafeForHighSpeed(Level level, BlockPos pos, AbstractMinecart cart) {
        if (!HighSpeedTrackUtil.isHighSpeedTrackAt((BlockGetter)level, pos)) {
            return false;
        }
        RailShape railShape = TrackUtil.getTrackDirection((BlockGetter)level, pos, cart);
        if (RailShapeUtil.isTurn(railShape)) {
            return false;
        }
        if (RailShapeUtil.isNorthSouth(railShape)) {
            BlockPos north = pos.m_122012_();
            BlockPos south = pos.m_122019_();
            return !(!HighSpeedTrackUtil.isTrackHighSpeedCapable(level, north) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, north.m_7494_()) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, north.m_7495_()) || !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, south) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, south.m_7494_()) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, south.m_7495_()));
        }
        if (RailShapeUtil.isEastWest(railShape)) {
            BlockPos east = pos.m_122029_();
            BlockPos west = pos.m_122024_();
            return !(!HighSpeedTrackUtil.isTrackHighSpeedCapable(level, east) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, east.m_7494_()) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, east.m_7495_()) || !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, west) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, west.m_7494_()) && !HighSpeedTrackUtil.isTrackHighSpeedCapable(level, west.m_7495_()));
        }
        return false;
    }

    private static boolean isTrackHighSpeedCapable(Level level, BlockPos pos) {
        return !level.m_46749_(pos) || HighSpeedTrackUtil.isHighSpeedTrackAt((BlockGetter)level, pos);
    }

    private static boolean isHighSpeedTrackAt(BlockGetter level, BlockPos pos) {
        return HighSpeedTrackUtil.getTrackTypeAt(level, pos, level.m_8055_(pos)).isHighSpeed();
    }

    private static TrackType getTrackTypeAt(BlockGetter level, BlockPos pos, BlockState state) {
        TrackType trackType;
        Block block = state.m_60734_();
        if (block instanceof TypedTrack) {
            TypedTrack typedTrack = (TypedTrack)block;
            trackType = typedTrack.getTrackType();
        } else {
            trackType = (TrackType)TrackTypes.IRON.get();
        }
        return trackType;
    }

    private static double speedForNextTrack(Level level, BlockPos pos, int dist, @Nullable AbstractMinecart cart) {
        double maxSpeed = (Double)RailcraftConfig.SERVER.highSpeedTrackMaxSpeed.get();
        if (dist >= 2) {
            return maxSpeed;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos nextPos = pos.m_121945_(direction);
            boolean foundTrack = BaseRailBlock.m_49364_((Level)level, (BlockPos)nextPos);
            if (!foundTrack) {
                if (BaseRailBlock.m_49364_((Level)level, (BlockPos)nextPos.m_7494_())) {
                    foundTrack = true;
                    nextPos = nextPos.m_7494_();
                } else if (BaseRailBlock.m_49364_((Level)level, (BlockPos)nextPos.m_7495_())) {
                    foundTrack = true;
                    nextPos = nextPos.m_7495_();
                }
            }
            if (!foundTrack) continue;
            RailShape railShape = TrackUtil.getTrackDirection((BlockGetter)level, nextPos, cart);
            if (railShape.m_61745_()) {
                return 0.45f;
            }
            maxSpeed = HighSpeedTrackUtil.speedForNextTrack(level, nextPos, dist + 1, cart);
            if (maxSpeed != (double)0.45f) continue;
            return 0.45f;
        }
        return maxSpeed;
    }
}

