/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.LockingTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.LockingMode;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LockingTrackBlock
extends PoweredOutfittedTrackBlock
implements EntityBlock {
    public static final Property<LockingMode> LOCKING_MODE = EnumProperty.m_61587_((String)"locking_mode", LockingMode.class);

    public LockingTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).m_61124_(LOCKING_MODE, (Comparable)((Object)LockingMode.LOCKDOWN));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LOCKING_MODE});
    }

    @Override
    protected boolean crowbarWhack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        return level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get()).map(lockingTrack -> lockingTrack.crowbarWhack(player)).orElse(false);
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, pos, cart);
        level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get()).ifPresent(lockingTrack -> lockingTrack.minecartPassed(cart));
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new LockingTrackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get()), LockingTrackBlockEntity::serverTick);
    }

    public static LockingMode getLockingMode(BlockState blockState) {
        return (LockingMode)((Object)blockState.m_61143_(LOCKING_MODE));
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.LOCKING_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_RELEASE_CARTS).m_130940_(ChatFormatting.RED));
    }
}

