/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class TransitionTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    private static final double BOOST_AMOUNT = 0.04;
    private static final double SLOW_FACTOR = 0.65;
    private static final double BOOST_THRESHOLD = 0.01;
    private static final double START_BOOST = 0.02;

    public TransitionTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return 16;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, pos, cart);
        boolean reversed = TransitionTrackBlock.isReversed(blockState);
        RailShape railShape = TransitionTrackBlock.getRailShapeRaw(blockState);
        if (!TransitionTrackBlock.isPowered(blockState)) {
            return;
        }
        Vec3 deltaMovement = cart.m_20184_();
        double speed = MinecartUtil.getCartSpeedUncapped(deltaMovement);
        if (speed <= 0.01) {
            MinecartUtil.startBoost(cart, pos, railShape, 0.02);
            return;
        }
        boolean highSpeed = RollingStock.getOrThrow(cart).isHighSpeed();
        if (RailShapeUtil.isNorthSouth(railShape)) {
            if (reversed ^ deltaMovement.m_7094_() < 0.0) {
                TransitionTrackBlock.boostCartSpeed(cart, speed);
            } else {
                TransitionTrackBlock.slowOrNormalCartSpeed(cart, highSpeed);
            }
        } else if (!reversed ^ deltaMovement.m_7096_() < 0.0) {
            TransitionTrackBlock.boostCartSpeed(cart, speed);
        } else {
            TransitionTrackBlock.slowOrNormalCartSpeed(cart, highSpeed);
        }
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)REVERSED, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)REVERSED) == false)));
        return true;
    }

    private static void boostCartSpeed(AbstractMinecart cart, double currentSpeed) {
        Vec3 motion = cart.m_20184_();
        cart.m_20256_(motion.m_82520_(motion.m_7096_() / currentSpeed * 0.04, 0.0, motion.m_7094_() / currentSpeed * 0.04));
    }

    private static void slowCartSpeed(AbstractMinecart cart) {
        if (cart instanceof Locomotive) {
            Locomotive locomotive = (Locomotive)cart;
            locomotive.forceIdle(20);
        }
        cart.m_20256_(cart.m_20184_().m_82542_(0.65, 1.0, 0.65));
    }

    private static void slowOrNormalCartSpeed(AbstractMinecart cart, boolean highSpeed) {
        if (highSpeed) {
            TransitionTrackBlock.slowCartSpeed(cart);
        } else {
            TransitionTrackBlock.normalCartSpeed(cart);
        }
    }

    private static void normalCartSpeed(AbstractMinecart cart) {
        Vec3 deltaMovement = cart.m_20184_();
        if (Math.abs(deltaMovement.m_7096_()) > 0.01) {
            cart.m_20334_(Math.copySign((double)0.3f, deltaMovement.m_7096_()), deltaMovement.m_7098_(), deltaMovement.m_7094_());
        }
        if (Math.abs(deltaMovement.m_7094_()) > 0.0) {
            cart.m_20334_(deltaMovement.m_7096_(), deltaMovement.m_7098_(), Math.copySign((double)0.3f, deltaMovement.m_7094_()));
        }
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.TRANSITION_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).m_130940_(ChatFormatting.RED));
    }
}

