/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.FluidTools;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import mods.railcraft.world.level.material.FluidItemHelper;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.ContainerModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TankModule
extends ContainerModule<TankBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_PROCESS = 1;
    public static final int SLOT_OUTPUT = 2;
    private final StandardTank tank;
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper(this){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 2) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    });
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int processTicks;

    public TankModule(TankBlockEntity provider, StandardTank tank) {
        super(provider, 3);
        this.tank = tank;
    }

    public StandardTank getTank() {
        return this.tank;
    }

    @Override
    public void serverTick() {
        if (this.processTicks++ >= 8) {
            this.processTicks = 0;
            this.processState = FluidTools.processContainer(this, this.tank, FluidTools.ProcessType.DRAIN_THEN_FILL, this.processState);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                if (!this.tank.isEmpty() && FluidItemHelper.isRoomInContainer(stack, this.tank.getFluidType())) break;
                if (!FluidUtil.getFluidContained((ItemStack)stack).isPresent()) return false;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.m_7013_(slot, stack)) return false;
        return true;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128359_("processState", this.processState.m_7912_());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.tank.readFromNBT(tag.m_128469_("tank"));
        this.processState = FluidTools.ProcessState.getByName(tag.m_128461_("processState")).orElse(FluidTools.ProcessState.RESET);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130130_(this.tank.getCapacity());
        out.writeFluidStack(this.tank.getFluid());
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.tank.setCapacity(in.m_130242_());
        this.tank.setFluid(in.readFluidStack());
    }
}

