/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import java.util.Objects;
import mods.railcraft.Railcraft;
import mods.railcraft.advancements.MinecartPredicate;
import mods.railcraft.util.JsonUtil;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.jetbrains.annotations.Nullable;

public class JukeboxCartPlayMusicTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = Railcraft.rl("jukebox_cart_play_music");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        ResourceLocation sound = JsonUtil.getAsString(json, "music").map(ResourceLocation::m_135820_).orElse(null);
        MinecartPredicate cart = JsonUtil.getAsJsonObject(json, "cart").map(MinecartPredicate::deserialize).orElse(MinecartPredicate.ANY);
        return new Instance(contextAwarePredicate, sound, cart);
    }

    public void trigger(ServerPlayer playerEntity, AbstractMinecart cart, ResourceLocation music) {
        this.m_66234_(playerEntity, criterionInstance -> criterionInstance.matches(playerEntity, cart, music));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final ResourceLocation music;
        private final MinecartPredicate cart;

        private Instance(ContextAwarePredicate contextAwarePredicate, @Nullable ResourceLocation music, MinecartPredicate cart) {
            super(ID, contextAwarePredicate);
            this.music = music;
            this.cart = cart;
        }

        public static Instance hasPlayedAnyMusic() {
            return new Instance(ContextAwarePredicate.f_285567_, null, MinecartPredicate.ANY);
        }

        public static Instance hasPlayedMusic(ResourceLocation music) {
            return new Instance(ContextAwarePredicate.f_285567_, music, MinecartPredicate.ANY);
        }

        public boolean matches(ServerPlayer player, AbstractMinecart cart, ResourceLocation sound) {
            return (this.music == null || Objects.equals(sound, this.music)) && this.cart.test(player, cart);
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = new JsonObject();
            if (this.music != null) {
                json.addProperty("music", this.music.toString());
            }
            json.add("cart", this.cart.serializeToJson());
            return json;
        }
    }
}

