/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import mods.railcraft.Railcraft;
import mods.railcraft.advancements.MinecartPredicate;
import mods.railcraft.season.Season;
import mods.railcraft.util.JsonUtil;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.jetbrains.annotations.Nullable;

public class SetSeasonTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = Railcraft.rl("set_season");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        Season season = JsonUtil.getAsString(json, "season").map(Integer::valueOf).map(x -> Season.values()[x]).orElse(null);
        MinecartPredicate cartPredicate = JsonUtil.getAsJsonObject(json, "cart").map(MinecartPredicate::deserialize).orElse(MinecartPredicate.ANY);
        return new Instance(contextAwarePredicate, season, cartPredicate);
    }

    public void trigger(ServerPlayer playerEntity, AbstractMinecart cart, Season target) {
        this.m_66234_(playerEntity, criterionInstance -> criterionInstance.matches(playerEntity, cart, target));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Season season;
        private final MinecartPredicate cartPredicate;

        private Instance(ContextAwarePredicate contextAwarePredicate, @Nullable Season season, MinecartPredicate predicate) {
            super(ID, contextAwarePredicate);
            this.season = season;
            this.cartPredicate = predicate;
        }

        public static Instance onSeasonSet() {
            return new Instance(ContextAwarePredicate.f_285567_, null, MinecartPredicate.ANY);
        }

        public boolean matches(ServerPlayer player, AbstractMinecart cart, Season target) {
            return (this.season == null || this.season.equals((Object)target)) && this.cartPredicate.test(player, cart);
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = new JsonObject();
            if (this.season != null) {
                json.addProperty("season", (Number)this.season.ordinal());
            }
            json.add("cart", this.cartPredicate.serializeToJson());
            return json;
        }
    }
}

