/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalController;
import mods.railcraft.api.signal.SingleSignalReceiver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public class DualSignalReceiver
extends SingleSignalReceiver {
    private static final Logger logger = LogUtils.getLogger();
    private final SingleSignalReceiver.SignalClient secondarySignalClient;

    public DualSignalReceiver(BlockEntity blockEntity, Runnable syncListener, Consumer<SignalAspect> primarySignalAspectListener, Consumer<SignalAspect> secondarySignalAspectListener) {
        super(blockEntity, syncListener, primarySignalAspectListener);
        this.secondarySignalClient = new SingleSignalReceiver.SignalClient(this, secondarySignalAspectListener);
    }

    public SignalAspect getSecondarySignalAspect() {
        return this.secondarySignalClient.getSignalAspect();
    }

    @Override
    public void linked(SignalController signalController) {
        if (this.primarySignalClient.getSignalController() == null) {
            super.linked(signalController);
            return;
        }
        if (this.secondarySignalClient.getSignalController() == null) {
            this.secondarySignalClient.linked(signalController);
            return;
        }
        this.primarySignalClient.unlinked();
        this.secondarySignalClient.unlinked();
        super.linked(signalController);
    }

    @Override
    public void unlinked(SignalController signalController) {
        if (this.primarySignalClient.getSignalControllerBlockPos().equals((Object)signalController.blockPos())) {
            this.primarySignalClient.unlinked();
        } else if (this.secondarySignalClient.getSignalControllerBlockPos().equals((Object)signalController.blockPos())) {
            this.secondarySignalClient.unlinked();
        } else {
            logger.warn("Signal controller @ [{}] tried to unlink with signal receiver @ [{}] without initially being linked", (Object)signalController.blockPos(), (Object)this.blockEntity.m_58899_());
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.secondarySignalClient.refresh();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.secondarySignalClient.unlink();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("secondarySignalClient", (Tag)this.secondarySignalClient.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.secondarySignalClient.deserializeNBT(tag.m_128469_("secondarySignalClient"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_130068_((Enum)this.secondarySignalClient.getSignalAspect());
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.secondarySignalClient.setSignalAspect((SignalAspect)data.m_130066_(SignalAspect.class));
    }
}

