/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.railcraft.api.util.EnumUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum SignalAspect implements StringRepresentable
{
    GREEN("green", 5),
    BLINK_YELLOW("blink_yellow", 3),
    YELLOW("yellow", 5),
    BLINK_RED("blink_red", 3),
    RED("red", 5),
    OFF("off", 0);

    private static final SignalAspect[] VALUES;
    private static final Map<String, SignalAspect> byName;
    private final String name;
    private final int blockLight;
    private final Component displayName;
    private static final int LAMP_LIGHT = 12;
    private static final int BLINK_DELAY_TICKS = 16;
    private static boolean blinkState;
    private static int blinkTimer;

    private SignalAspect(String name, int blockLight) {
        this.name = name;
        this.blockLight = blockLight;
        this.displayName = Component.m_237115_((String)("signal.railcraft.aspect." + name));
    }

    public int getBlockLight() {
        return this.blockLight;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public String m_7912_() {
        return this.name;
    }

    public int getLampLight() {
        return this == OFF ? 0 : 12;
    }

    public boolean isBlinkAspect() {
        return this == BLINK_YELLOW || this == BLINK_RED;
    }

    public boolean isOffState() {
        return this == OFF || this.isBlinkAspect() && !SignalAspect.getBlinkState();
    }

    public SignalAspect getDisplayAspect() {
        if (this.isOffState()) {
            return OFF;
        }
        if (this == BLINK_YELLOW) {
            return YELLOW;
        }
        if (this == BLINK_RED) {
            return RED;
        }
        return this;
    }

    public SignalAspect next() {
        return (SignalAspect)EnumUtil.next((Enum)this, (Enum[])VALUES);
    }

    public SignalAspect previous() {
        return (SignalAspect)EnumUtil.previous((Enum)this, (Enum[])VALUES);
    }

    public static boolean getBlinkState() {
        return blinkState;
    }

    public static void tickBlinkState() {
        if (blinkTimer++ >= 16) {
            blinkTimer = 0;
            blinkState = !blinkState;
        }
    }

    public static SignalAspect mostRestrictive(@Nullable SignalAspect first, @Nullable SignalAspect second) {
        if (first == null && second == null) {
            return RED;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first.ordinal() > second.ordinal()) {
            return first;
        }
        return second;
    }

    public static Optional<SignalAspect> getByName(String name) {
        return Optional.ofNullable(byName.get(name));
    }

    static {
        VALUES = SignalAspect.values();
        byName = Arrays.stream(VALUES).collect(Collectors.toUnmodifiableMap(SignalAspect::m_7912_, Function.identity()));
    }
}

