/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import java.util.Random;
import java.util.stream.Stream;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeCartStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;

public class ChargeCartStorageImpl
extends EnergyStorage
implements ChargeCartStorage {
    protected static final Random RANDOM = new Random();
    private static final int DRAW_INTERVAL = 8;
    protected final int lossPerTick;
    protected double draw;
    protected double chargeDrawnThisTick;
    protected int drewFromTrack;
    protected int clock = RANDOM.nextInt(0, 8);

    public ChargeCartStorageImpl(int capacity) {
        this(capacity, 0);
    }

    public ChargeCartStorageImpl(int capacity, int lossPerTick) {
        super(capacity);
        this.lossPerTick = lossPerTick;
    }

    @Override
    public double getLosses() {
        return this.lossPerTick;
    }

    @Override
    public double getDraw() {
        return this.draw;
    }

    protected void removeLosses() {
        if (this.lossPerTick > 0) {
            this.energy = this.energy >= this.lossPerTick ? (this.energy -= this.lossPerTick) : 0;
        }
    }

    @Override
    public void tick(AbstractMinecart owner) {
        if (owner.m_9236_().m_5776_()) {
            return;
        }
        ++this.clock;
        this.removeLosses();
        this.draw = (this.draw * 24.0 + this.chargeDrawnThisTick) / 25.0;
        this.chargeDrawnThisTick = 0.0;
        if (this.drewFromTrack > 0) {
            --this.drewFromTrack;
        } else if ((double)this.energy < (double)this.capacity * 0.5 && this.clock % 8 == 0) {
            RollingStock.getOrThrow(owner).train().entities().flatMap(c -> c.getCapability(ForgeCapabilities.ENERGY).map(Stream::of).orElse(Stream.empty())).findAny().ifPresent(energyStorage -> this.energy += energyStorage.extractEnergy(this.capacity - this.energy, false));
        }
    }

    @Override
    public void tickOnTrack(AbstractMinecart owner, BlockPos pos) {
        if (!owner.m_9236_().m_5776_() && this.needsCharging()) {
            int drawnFromTrack = Charge.distribution.network((ServerLevel)owner.m_9236_()).access(pos).removeCharge(this.capacity - this.energy, false);
            if (drawnFromTrack > 0) {
                this.drewFromTrack = 32;
            }
            this.energy += drawnFromTrack;
        }
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate) {
            this.chargeDrawnThisTick += (double)extracted;
        }
        return extracted;
    }

    private boolean needsCharging() {
        return this.energy < this.capacity;
    }
}

