/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetAnalogSignalControllerBoxAttributesMessage;
import mods.railcraft.world.level.block.entity.signal.AnalogSignalControllerBoxBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class AnalogSignalControllerBoxScreen
extends IngameWindowScreen {
    private final AnalogSignalControllerBoxBlockEntity signalBox;
    private static final Pattern PATTERN_RANGE = Pattern.compile("(\\d+)-(\\d+)|(\\d+)");
    private final Map<SignalAspect, BitSet> signalAspectTriggerSignals = new EnumMap<SignalAspect, BitSet>(SignalAspect.class);
    private final Map<SignalAspect, EditBox> textFields = new EnumMap<SignalAspect, EditBox>(SignalAspect.class);

    public AnalogSignalControllerBoxScreen(AnalogSignalControllerBoxBlockEntity signalBox) {
        super(signalBox.m_5446_(), LARGE_WINDOW_TEXTURE, 176, 113);
        this.signalBox = signalBox;
        for (Map.Entry<SignalAspect, BitSet> entry : signalBox.getSignalAspectTriggerSignals().entrySet()) {
            this.signalAspectTriggerSignals.put(entry.getKey(), (BitSet)entry.getValue().clone());
        }
    }

    private String rangeToString(BitSet b) {
        StringBuilder s = new StringBuilder();
        int start = -1;
        for (int i = 0; i < 16; ++i) {
            if (b.get(i)) {
                if (start != -1) continue;
                s.append(i);
                start = i;
                continue;
            }
            if (start == -1) continue;
            if (i - 1 == start) {
                s.append(",");
            } else {
                s.append("-").append(i - 1).append(",");
            }
            start = -1;
        }
        if (start != -1 && start != 15) {
            s.append("-15");
            start = 15;
        }
        if (s.length() == 0 || start == 15) {
            return s.toString();
        }
        return s.substring(0, s.length() - 1);
    }

    private void parseRegex(String regex, BitSet bits) {
        bits.clear();
        Matcher m = PATTERN_RANGE.matcher(regex);
        while (m.find()) {
            if (m.groupCount() >= 3 && m.group(3) != null) {
                int i = Integer.parseInt(m.group(3));
                if (i < 0 || i > 15) continue;
                bits.set(i);
                continue;
            }
            int start = Integer.parseInt(m.group(1));
            int end = Integer.parseInt(m.group(2));
            if (start < 0 || end < 0 || end > 15 || start > end) continue;
            for (int i = start; i <= end; ++i) {
                bits.set(i);
            }
        }
    }

    public void m_7856_() {
        int centeredX = (this.f_96543_ - this.windowWidth) / 2;
        int centeredY = (this.f_96544_ - this.windowHeight) / 2;
        for (Map.Entry<SignalAspect, BitSet> entry : this.signalAspectTriggerSignals.entrySet()) {
            EditBox textField = new EditBox(this.f_96547_, centeredX + 72, centeredY + AnalogSignalControllerBoxScreen.getYPosFromIndex(entry.getKey().ordinal()), 95, 10, entry.getKey().getDisplayName());
            textField.m_94199_(37);
            textField.m_94144_(this.rangeToString(entry.getValue()));
            textField.m_94153_(string -> {
                for (char ch : string.toCharArray()) {
                    if (Character.isDigit(ch) || ch == ',' || ch == '-') continue;
                    return false;
                }
                return true;
            });
            this.m_142416_((GuiEventListener)textField);
            this.textFields.put(entry.getKey(), textField);
        }
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (SignalAspect aspect : SignalAspect.values()) {
            guiGraphics.m_280614_(this.f_96547_, aspect.getDisplayName(), 10, AnalogSignalControllerBoxScreen.getYPosFromIndex(aspect.ordinal()) + 1, -12566464, false);
        }
    }

    public void m_7861_() {
        if (this.f_96541_.f_91073_ != null && this.f_96541_.f_91073_.m_5776_()) {
            for (Map.Entry<SignalAspect, BitSet> entry : this.signalAspectTriggerSignals.entrySet()) {
                this.parseRegex(this.textFields.get((Object)entry.getKey()).m_94155_(), entry.getValue());
            }
            this.signalBox.setSignalAspectTriggerSignals(this.signalAspectTriggerSignals);
            NetworkChannel.GAME.sendToServer(new SetAnalogSignalControllerBoxAttributesMessage(this.signalBox.m_58899_(), this.signalAspectTriggerSignals));
        }
    }

    private static int getYPosFromIndex(int i) {
        return 22 + i * 14;
    }
}

