/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.client.gui.widget.button.ToggleButton;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetLocomotiveAttributesMessage;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.LocomotiveMenu;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public abstract class LocomotiveScreen<T extends LocomotiveMenu<?>>
extends RailcraftMenuScreen<T> {
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final String typeTag;
    private final Map<Locomotive.Mode, Button> modeButtons = new EnumMap<Locomotive.Mode, Button>(Locomotive.Mode.class);
    private final Map<Locomotive.Speed, Button> speedButtons = new EnumMap<Locomotive.Speed, Button>(Locomotive.Speed.class);
    private ToggleButton reverseButton;
    private MultiButton<Locomotive.Lock> lockButton;
    private int refreshTimer;

    protected LocomotiveScreen(T menu, Inventory inventory, Component title, String typeTag) {
        super(menu, inventory, title);
        this.typeTag = typeTag;
        this.f_97727_ = 161;
        this.f_97731_ = this.f_97727_ - 94;
    }

    private Optional<Tooltip> createLockTooltip(Locomotive.Lock lock) {
        return Optional.of(Tooltip.m_257550_((Component)(switch (lock) {
            default -> throw new IncompatibleClassChangeError();
            case Locomotive.Lock.LOCKED -> Component.m_237110_((String)Translations.Screen.LOCOMOTIVE_LOCK_LOCKED, (Object[])new Object[]{((LocomotiveMenu)this.f_97732_).getLocomotive().getOwnerOrThrow().getName()});
            case Locomotive.Lock.UNLOCKED -> Component.m_237115_((String)Translations.Screen.LOCOMOTIVE_LOCK_UNLOCKED);
            case Locomotive.Lock.PRIVATE -> Component.m_237110_((String)Translations.Screen.LOCOMOTIVE_LOCK_PRIVATE, (Object[])new Object[]{((LocomotiveMenu)this.f_97732_).getLocomotive().getOwnerOrThrow().getName()});
        })));
    }

    public void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        for (Locomotive.Mode mode : ((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).getSupportedModes()) {
            String translationKey = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Locomotive.Mode.IDLE -> Translations.Screen.LOCOMOTIVE_MODE_IDLE;
                case Locomotive.Mode.SHUTDOWN -> Translations.Screen.LOCOMOTIVE_MODE_SHUTDOWN;
                case Locomotive.Mode.RUNNING -> Translations.Screen.LOCOMOTIVE_MODE_RUNNING;
            };
            MutableComponent tooltip = Component.m_237115_((String)Translations.makeKey("screen", String.format("locomotive.%s.mode.description.%s", this.typeTag, mode.m_7912_())));
            RailcraftButton button = ((RailcraftButton.Builder)((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(translationKey, __ -> this.setMode(mode), (TexturePosition)ButtonTexture.SMALL_BUTTON).pos(0, centreY + this.getYSize() - 129)).size(55, 16)).tooltip(Tooltip.m_257550_((Component)tooltip))).build();
            this.modeButtons.put(mode, button);
        }
        GuiUtil.newButtonRowAuto(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, centreX + 3, 171, this.modeButtons.values());
        this.reverseButton = (ToggleButton)this.m_142416_((GuiEventListener)((ToggleButton)((ToggleButton.Builder)ToggleButton.toggleBuilder((Component)Component.m_237113_((String)"R"), __ -> this.toggleReverse(), ButtonTexture.SMALL_BUTTON).bounds(centreX + 4, centreY + this.getYSize() - 112, 12, 16)).toggled(((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).isReverse()).build()));
        for (Locomotive.Speed speed : Locomotive.Speed.values()) {
            String label = IntStream.range(0, speed.getLevel()).mapToObj(i -> ">").collect(Collectors.joining());
            RailcraftButton button = ((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder((Component)Component.m_237113_((String)label), __ -> this.setSpeed(speed), (TexturePosition)ButtonTexture.SMALL_BUTTON).pos(0, centreY + this.getYSize() - 112)).size(7 + speed.getLevel() * 5, 16)).build();
            button.f_93623_ = ((Locomotive)((LocomotiveMenu)this.f_97732_).getLocomotive()).getSpeed() == speed;
            this.speedButtons.put(speed, button);
        }
        GuiUtil.newButtonRow(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, centreX + 21, 5, this.speedButtons.values());
        this.lockButton = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, ((Locomotive)((LocomotiveMenu)this.f_97732_).getLocomotive()).getLock()).bounds(centreX + 152, centreY + this.getYSize() - 111, 16, 16)).tooltipFactory(this::createLockTooltip).stateCallback(this::setLock).build()));
        this.updateButtons();
    }

    private void setMode(Locomotive.Mode mode) {
        if (((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).getMode() != mode) {
            ((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).setMode(mode);
            this.sendAttributes();
        }
    }

    private void setSpeed(Locomotive.Speed speed) {
        if (((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).getSpeed() != speed) {
            ((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).setSpeed(speed);
            this.sendAttributes();
        }
    }

    private void setLock(Locomotive.Lock lock) {
        if (((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).getLock() != lock) {
            ((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).setLock(lock);
            ((Locomotive)((LocomotiveMenu)this.f_97732_).getLocomotive()).setOwner(lock == Locomotive.Lock.UNLOCKED ? null : this.f_96541_.m_91094_().m_92548_());
            this.sendAttributes();
        }
    }

    private void toggleReverse() {
        ((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).setReverse(!((Locomotive)((LocomotiveMenu)this.m_6262_()).getLocomotive()).isReverse());
        this.sendAttributes();
    }

    protected void sendAttributes() {
        this.updateButtons();
        Object locomotive = ((LocomotiveMenu)this.m_6262_()).getLocomotive();
        NetworkChannel.GAME.sendToServer(new SetLocomotiveAttributesMessage(((LocomotiveMenu)this.f_97732_).getLocomotive().m_19879_(), ((Locomotive)locomotive).getMode(), ((Locomotive)locomotive).getSpeed(), ((Locomotive)locomotive).getLock(), ((Locomotive)locomotive).isReverse()));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.updateButtons();
        }
    }

    private void updateButtons() {
        Object locomotive = ((LocomotiveMenu)this.m_6262_()).getLocomotive();
        this.modeButtons.forEach((mode, button) -> {
            button.f_93623_ = locomotive.getMode() != mode && locomotive.isAllowedMode((Locomotive.Mode)((Object)mode));
        });
        this.speedButtons.forEach((speed, button) -> {
            button.f_93623_ = locomotive.getSpeed() != speed && (!locomotive.isReverse() || speed.getLevel() <= locomotive.getMaxReverseSpeed().getLevel());
        });
        this.reverseButton.setToggled(((Locomotive)locomotive).isReverse());
        this.lockButton.f_93623_ = !((Locomotive)locomotive).isLocked() || locomotive.getOwnerOrThrow().equals((Object)this.f_96541_.m_91094_().m_92548_());
        this.lockButton.setState(((Locomotive)locomotive).getLock());
    }
}

