/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mods.railcraft.Railcraft;
import mods.railcraft.api.carts.TunnelBoreHead;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.model.TunnelBoreModel;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class TunnelBoreRenderer
extends EntityRenderer<TunnelBore> {
    private static final ResourceLocation TEXTURE = Railcraft.rl("textures/entity/tunnel_bore/tunnel_bore.png");
    protected TunnelBoreModel modelTunnelBore;

    public TunnelBoreRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        this.modelTunnelBore = new TunnelBoreModel(context.m_174023_(RailcraftModelLayers.TUNNEL_BORE));
    }

    public void render(TunnelBore bore, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int packedLight) {
        ResourceLocation textureLocation;
        boolean ghostTrain;
        matrixStack.m_85836_();
        long var10 = (long)bore.m_19879_() * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float tx = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float ty = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float tz = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        matrixStack.m_252880_(tx, ty, tz);
        matrixStack.m_252880_(0.0f, 0.375f, 0.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        float roll = (float)bore.m_38176_() - partialTicks;
        float damage = bore.m_38169_() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (roll > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)roll) * roll * damage / 10.0f * (float)bore.m_38177_()));
        }
        float colorIntensity = (ghostTrain = Seasons.isGhostTrain((AbstractMinecart)bore)) ? 0.5f : 1.0f;
        TunnelBoreHead head = bore.getBoreHead();
        if (head != null) {
            textureLocation = head.getTextureLocation();
            this.modelTunnelBore.setRenderBoreHead(true);
        } else {
            textureLocation = TEXTURE;
            this.modelTunnelBore.setRenderBoreHead(false);
        }
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.modelTunnelBore.setBoreHeadRotation(bore.getBoreRotationAngle());
        this.modelTunnelBore.setBoreActive(bore.isMinecartPowered());
        this.modelTunnelBore.setupAnim(bore, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexBuilder = renderTypeBuffer.m_6299_(this.modelTunnelBore.m_103119_(textureLocation));
        this.modelTunnelBore.m_7695_(matrixStack, vertexBuilder, packedLight, OverlayTexture.f_118083_, colorIntensity, colorIntensity, colorIntensity, ghostTrain ? 0.8f : 1.0f);
        matrixStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(TunnelBore entity) {
        TunnelBoreHead head = entity.getBoreHead();
        return head == null ? TEXTURE : head.getTextureLocation();
    }
}

