/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.material.FluidItemHelper;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class FluidTools {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int PROCESS_VOLUME = 4000;

    private FluidTools() {
    }

    public static Component toString(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return Component.m_237113_((String)"Empty");
        }
        return Component.m_237113_((String)(fluidStack.getAmount() + "x")).m_7220_(fluidStack.getDisplayName());
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, IFluidHandler fluidHandler) {
        return player.m_9236_().m_5776_() ? FluidItemHelper.isContainer(player.m_21120_(hand)) : FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)fluidHandler);
    }

    private static void sendToProcessing(Container container) {
        ContainerMapper.make(container, 0, 1).moveOneItemTo(ContainerMapper.make(container, 1, 1).ignoreItemChecks());
    }

    private static void sendToOutput(Container container) {
        ContainerMapper.make(container, 1, 1).moveOneItemTo(ContainerMapper.make(container, 2, 1).ignoreItemChecks());
    }

    private static ProcessState tryFill(Container container, StandardTank tank, ItemStack itemStack) {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, null, (boolean)true);
        if (!result.isSuccess()) {
            FluidTools.sendToOutput(container);
            return ProcessState.RESET;
        }
        container.m_6836_(1, result.getResult());
        return ProcessState.FILLING;
    }

    private static ProcessState tryDrain(Container container, StandardTank tank, ItemStack itemStack) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, null, (boolean)true);
        if (!result.isSuccess()) {
            FluidTools.sendToOutput(container);
            return ProcessState.RESET;
        }
        container.m_6836_(1, result.getResult());
        return ProcessState.DRAINING;
    }

    public static ProcessState processContainer(Container container, StandardTank tank, ProcessType type, ProcessState state) {
        ItemStack itemStack = container.m_8020_(1);
        if (itemStack.m_41619_() || !FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent()) {
            FluidTools.sendToProcessing(container);
            return ProcessState.RESET;
        }
        if (state == ProcessState.RESET) {
            if (type == ProcessType.FILL_ONLY) {
                return FluidTools.tryFill(container, tank, itemStack);
            }
            if (type == ProcessType.DRAIN_ONLY) {
                return FluidTools.tryDrain(container, tank, itemStack);
            }
            if (type == ProcessType.FILL_THEN_DRAIN) {
                if (FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, null, (boolean)false).isSuccess()) {
                    return FluidTools.tryFill(container, tank, itemStack);
                }
                return FluidTools.tryDrain(container, tank, itemStack);
            }
            if (type == ProcessType.DRAIN_THEN_FILL) {
                if (FluidUtil.getFluidContained((ItemStack)itemStack).isPresent() && !tank.isFull()) {
                    return FluidTools.tryDrain(container, tank, itemStack);
                }
                return FluidTools.tryFill(container, tank, itemStack);
            }
        }
        if (state == ProcessState.FILLING) {
            return FluidTools.tryFill(container, tank, itemStack);
        }
        if (state == ProcessState.DRAINING) {
            return FluidTools.tryDrain(container, tank, itemStack);
        }
        return state;
    }

    public static boolean isFullFluidBlock(Level level, BlockPos pos) {
        return FluidTools.isFullFluidBlock(level.m_8055_(pos), level, pos);
    }

    public static boolean isFullFluidBlock(BlockState state, Level level, BlockPos pos) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0;
        }
        Block block = state.m_60734_();
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return (double)Math.abs(fluidBlock.getFilledPercentage(level, pos)) == 1.0;
        }
        return false;
    }

    public static Fluid getFluid(BlockState state) {
        return state.m_60819_().m_76152_();
    }

    public static Collection<IFluidHandler> findNeighbors(Level level, BlockPos centrePos, Predicate<BlockEntity> filter, Direction ... directions) {
        ArrayList<IFluidHandler> targets = new ArrayList<IFluidHandler>();
        for (Direction direction : directions) {
            BlockEntity blockEntity = level.m_7702_(centrePos.m_121945_(direction));
            if (blockEntity == null || !TankManager.TANK_FILTER.apply(blockEntity, direction.m_122424_()).booleanValue() || !filter.test(blockEntity)) continue;
            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(targets::add);
        }
        return targets;
    }

    public static enum ProcessState implements StringRepresentable
    {
        FILLING("filling"),
        DRAINING("draining"),
        RESET("reset");

        private static final Map<String, ProcessState> byName;
        private final String name;

        private ProcessState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Optional<ProcessState> getByName(String name) {
            return Optional.ofNullable(byName.get(name));
        }

        static {
            byName = Arrays.stream(ProcessState.values()).collect(Collectors.toUnmodifiableMap(ProcessState::m_7912_, Function.identity()));
        }
    }

    public static enum ProcessType {
        FILL_ONLY,
        DRAIN_ONLY,
        FILL_THEN_DRAIN,
        DRAIN_THEN_FILL;

    }
}

