/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.railcraft.api.core.RailcraftFakePlayer;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.item.CartItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MinecartUtil {
    private MinecartUtil() {
    }

    public static double getCartSpeedUncapped(Vec3 deltaMovement) {
        return Math.sqrt(MinecartUtil.getCartSpeedUncappedSquared(deltaMovement));
    }

    public static double getCartSpeedUncappedSquared(Vec3 deltaMovement) {
        return deltaMovement.m_7096_() * deltaMovement.m_7096_() + deltaMovement.m_7094_() * deltaMovement.m_7094_();
    }

    public static boolean cartVelocityIsLessThan(AbstractMinecart minecart, float velocity) {
        return MinecartUtil.cartVelocityIsLessThan(minecart.m_20184_(), velocity);
    }

    public static boolean cartVelocityIsLessThan(Vec3 deltaMovement, float velocity) {
        return Math.abs(deltaMovement.m_7096_()) < (double)velocity && Math.abs(deltaMovement.m_7094_()) < (double)velocity;
    }

    public static void explodeCart(AbstractMinecart cart) {
        if (!cart.m_6084_()) {
            return;
        }
        cart.m_20334_(0.0, cart.m_20184_().m_7098_(), 0.0);
        if (cart.m_9236_().m_5776_()) {
            return;
        }
        MinecartUtil.removePassengers(cart, cart.m_20185_(), cart.m_20186_() + 1.5, cart.m_20189_());
        cart.m_9236_().m_254849_((Entity)cart, cart.m_20185_(), cart.m_20186_(), cart.m_20189_(), 3.0f, Level.ExplosionInteraction.TNT);
        if (cart.m_9236_().m_213780_().m_188503_(2) == 0) {
            cart.m_6074_();
        }
    }

    public static List<UUID> getMinecartUUIDsAt(Level level, BlockPos pos, float sensitivity) {
        return MinecartUtil.getMinecartUUIDsAt(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), sensitivity);
    }

    public static List<UUID> getMinecartUUIDsAt(Level level, int x, int y, int z, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        return level.m_6443_(AbstractMinecart.class, new AABB((double)((float)x + sensitivity), (double)((float)y + sensitivity), (double)((float)z + sensitivity), (double)((float)(x + 1) - sensitivity), (double)((float)(y + 1) - sensitivity), (double)((float)(z + 1) - sensitivity)), EntitySelector.f_20402_).stream().map(Entity::m_20148_).collect(Collectors.toList());
    }

    public static void removePassengers(AbstractMinecart cart) {
        MinecartUtil.removePassengers(cart, cart.m_20185_(), cart.m_20186_(), cart.m_20189_());
    }

    public static void removePassengers(AbstractMinecart cart, double x, double y, double z) {
        List passengers = cart.m_20197_();
        cart.m_20153_();
        for (Entity entity : passengers) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.m_6034_(x, y, z);
                continue;
            }
            entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
        }
    }

    public static ServerPlayer getFakePlayer(AbstractMinecart cart) {
        return RailcraftFakePlayer.get((ServerLevel)cart.m_9236_(), cart.m_20185_(), cart.m_20186_(), cart.m_20189_());
    }

    public static ServerPlayer getFakePlayerWith(AbstractMinecart cart, ItemStack stack) {
        ServerPlayer player = MinecartUtil.getFakePlayer(cart);
        player.m_21008_(InteractionHand.MAIN_HAND, stack);
        return player;
    }

    public static boolean isInRangeToRenderDist(AbstractMinecart entity, double distance) {
        double range = entity.m_20191_().m_82309_();
        if (Double.isNaN(range)) {
            range = 1.0;
        }
        return distance < (range = range * 64.0 * 4.0) * range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static AbstractMinecart getCartFromUUID(@Nullable Level level, @Nullable UUID id) {
        if (level == null) return null;
        if (id == null) {
            return null;
        }
        if (!(level instanceof ServerLevel)) return MinecartUtil.getClientCartFromUUID(level, id);
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = serverLevel.m_8791_(id);
        if (!(entity instanceof AbstractMinecart)) return null;
        AbstractMinecart cart = (AbstractMinecart)entity;
        if (!entity.m_6084_()) return null;
        AbstractMinecart abstractMinecart = cart;
        return abstractMinecart;
    }

    private static AbstractMinecart getClientCartFromUUID(Level level, UUID id) {
        if (!(level instanceof ClientLevel)) {
            return null;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        for (Entity entity : clientLevel.m_104735_()) {
            if (!(entity instanceof AbstractMinecart)) continue;
            AbstractMinecart abstractMinecart = (AbstractMinecart)entity;
            if (!entity.m_6084_() || !entity.m_20148_().equals(id)) continue;
            return abstractMinecart;
        }
        return null;
    }

    public static boolean startBoost(AbstractMinecart cart, BlockPos pos, RailShape dir, double startBoost) {
        Level level = cart.m_9236_();
        if (dir == RailShape.EAST_WEST) {
            if (Block.m_49863_((LevelReader)level, (BlockPos)pos.m_122024_(), (Direction)Direction.EAST)) {
                Vec3 motion = cart.m_20184_();
                cart.m_20334_(startBoost, motion.m_7098_(), motion.m_7094_());
                return true;
            }
            if (Block.m_49863_((LevelReader)level, (BlockPos)pos.m_122029_(), (Direction)Direction.WEST)) {
                Vec3 motion = cart.m_20184_();
                cart.m_20334_(-startBoost, motion.m_7098_(), motion.m_7094_());
                return true;
            }
        } else if (dir == RailShape.NORTH_SOUTH) {
            if (Block.m_49863_((LevelReader)level, (BlockPos)pos.m_122012_(), (Direction)Direction.SOUTH)) {
                Vec3 motion = cart.m_20184_();
                cart.m_20334_(motion.m_7096_(), motion.m_7098_(), startBoost);
                return true;
            }
            if (Block.m_49863_((LevelReader)level, (BlockPos)pos.m_122019_(), (Direction)Direction.NORTH)) {
                Vec3 motion = cart.m_20184_();
                cart.m_20334_(motion.m_7096_(), motion.m_7098_(), -startBoost);
                return true;
            }
        }
        return false;
    }

    public static void smackCart(AbstractMinecart cart, Player smacker, float smackVelocity) {
        MinecartUtil.smackCart(cart, cart, smacker, smackVelocity);
    }

    public static void smackCart(AbstractMinecart respect, AbstractMinecart cart, Player smacker, float smackVelocity) {
        cart.m_20256_(cart.m_20184_().m_82520_(Math.copySign((double)smackVelocity, respect.m_20185_() - smacker.m_20185_()), 0.0, Math.copySign((double)smackVelocity, respect.m_20189_() - smacker.m_20189_())));
    }

    public static void initCartPos(AbstractMinecart entity, double x, double y, double z) {
        entity.m_6034_(x, y, z);
        entity.m_146867_();
        entity.m_20256_(Vec3.f_82478_);
    }

    @Nullable
    public static AbstractMinecart placeCart(ItemStack cartItem, ServerLevel level, BlockPos pos) {
        if (cartItem.m_41619_()) {
            return null;
        }
        BlockState blockState = level.m_8055_(pos);
        if (!TrackUtil.isStraightTrackAt((BlockGetter)level, pos)) {
            return null;
        }
        if (EntitySearcher.findMinecarts().at(pos).list((Level)level).isEmpty()) {
            RailShape trackShape = TrackUtil.getTrackDirection((BlockGetter)level, pos, blockState);
            double h = trackShape.m_61745_() ? 0.5 : 0.0;
            ItemStack cartStack = cartItem.m_41777_();
            AbstractMinecart cart = null;
            Item item = cartItem.m_41720_();
            if (item instanceof CartItem) {
                CartItem railcraftCartItem = (CartItem)item;
                cart = railcraftCartItem.getMinecartFactory().createMinecart(cartStack, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.0625 + h, (double)pos.m_123343_() + 0.5, level);
            } else {
                item = cartItem.m_41720_();
                if (item instanceof MinecartItem) {
                    MinecartItem minecartItem = (MinecartItem)item;
                    cart = AbstractMinecart.m_38119_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.0625 + h), (double)((double)pos.m_123343_() + 0.5), (AbstractMinecart.Type)minecartItem.f_42935_);
                }
            }
            if (cart == null) {
                return null;
            }
            if (cartStack.m_41788_()) {
                cart.m_6593_(cartStack.m_41611_());
            }
            level.m_7967_(cart);
            return cart;
        }
        return null;
    }
}

