/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.Translations;
import mods.railcraft.util.PlayerUtil;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TicketItem
extends Item {
    public static final Predicate<ItemStack> FILTER = stack -> stack != null && stack.m_41720_() instanceof TicketItem;
    public static final int LINE_LENGTH = 32;

    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        String dest = TicketItem.getDestination(stack);
        if (!dest.isEmpty()) {
            String pretty_dest = dest.substring(dest.lastIndexOf("/") + 1);
            name = name.m_6881_().m_130946_(" - " + pretty_dest);
        }
        return name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (stack.m_41782_()) {
            GameProfile owner = TicketItem.getOwner(stack);
            if (owner != null) {
                list.add((Component)Component.m_237115_((String)Translations.Tips.ROUTING_TICKET_ISSUER));
                list.add((Component)PlayerUtil.getUsername(level, owner).m_6881_().m_130940_(ChatFormatting.GRAY));
            }
            String dest = TicketItem.getDestination(stack);
            list.add((Component)Component.m_237115_((String)Translations.Tips.ROUTING_TICKET_DEST));
            if (dest.isEmpty()) {
                list.add((Component)Component.m_237115_((String)Translations.Tips.CLEAR).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add((Component)Component.m_237113_((String)dest).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            list.add((Component)Component.m_237115_((String)Translations.Tips.ROUTING_TICKET_BLANK).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public static ItemStack copyTicket(ItemStack source) {
        if (source.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (source.m_41720_() instanceof TicketItem) {
            ItemStack ticket = ((Item)RailcraftItems.TICKET.get()).m_7968_();
            if (ticket.m_41619_()) {
                return ItemStack.f_41583_;
            }
            CompoundTag tag = source.m_41783_();
            if (tag != null) {
                ticket.m_41751_(tag.m_6426_());
            }
            return ticket;
        }
        return ItemStack.f_41583_;
    }

    public static boolean setTicketData(ItemStack ticket, String dest, @Nullable GameProfile owner) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem)) {
            return false;
        }
        if (dest.length() > 32) {
            return false;
        }
        if (owner == null) {
            return false;
        }
        CompoundTag tag = ticket.m_41784_();
        tag.m_128359_("dest", dest);
        NbtUtils.m_129230_((CompoundTag)tag, (GameProfile)owner);
        return true;
    }

    public static String getDestination(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem)) {
            return "";
        }
        CompoundTag tag = ticket.m_41783_();
        if (tag == null) {
            return "";
        }
        return tag.m_128461_("dest");
    }

    @Nullable
    public static GameProfile getOwner(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem)) {
            return null;
        }
        CompoundTag tag = ticket.m_41783_();
        if (tag == null) {
            return null;
        }
        return NbtUtils.m_129228_((CompoundTag)tag);
    }
}

