/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.enchantment;

import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import mods.railcraft.util.Predicates;
import mods.railcraft.world.item.enchantment.RailcraftToolEnchantment;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.extensions.IForgeEnchantment;
import org.jetbrains.annotations.Nullable;

public class RailcraftDamageEnchantment
extends RailcraftToolEnchantment
implements IForgeEnchantment {
    private final int baseEnchantability;
    private final int levelEnchantability;
    private final int thresholdEnchantability;
    private final Predicate<? super Entity> check;
    private final float damageBonusPerLevel;
    private WeakReference<Entity> target;

    public RailcraftDamageEnchantment(Enchantment.Rarity rarity, int baseEnchantability, int levelEnchantability, int thresholdEnchantability, @Nullable Predicate<? super Entity> check, float damageBonusPerLevel) {
        super(rarity, EquipmentSlot.MAINHAND);
        this.baseEnchantability = baseEnchantability;
        this.levelEnchantability = levelEnchantability;
        this.thresholdEnchantability = thresholdEnchantability;
        this.check = check == null ? Predicates.alwaysTrue() : check;
        this.damageBonusPerLevel = damageBonusPerLevel;
    }

    public int m_6183_(int level) {
        return this.baseEnchantability + (level - 1) * this.levelEnchantability;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + this.thresholdEnchantability;
    }

    public int m_6586_() {
        return 5;
    }

    public float getDamageBonus(int level, MobType mobType, ItemStack enchantedItem) {
        float modifier = 0.0f;
        if (this.target != null && this.check.test((Entity)this.target.get())) {
            modifier = (float)level * this.damageBonusPerLevel;
        }
        this.target = null;
        return modifier;
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof RailcraftDamageEnchantment) && !(enchantment instanceof DamageEnchantment);
    }
}

