/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Optional;
import java.util.stream.Stream;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.FluidTransferHandler;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.FluidTools;
import mods.railcraft.util.Predicates;
import mods.railcraft.world.entity.vehicle.locomotive.SteamLocomotive;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidLoaderBlockEntity
extends FluidManipulatorBlockEntity {
    private static final int RESET_WAIT = 200;
    private static final int TRANSFER_RATE = 20;
    private static final float MAX_PIPE_LENGTH = 1.25f;
    private static final float PIPE_INCREMENT = 0.01f;
    private static final Direction[] PULL_FROM = (Direction[])Stream.of(Direction.values()).filter(direction -> direction != Direction.DOWN).toArray(Direction[]::new);
    private float lastPipeLength;
    private float pipeLength;

    public FluidLoaderBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get(), blockPos, blockState);
    }

    private void resetPipeLength() {
        this.pipeLength = 0.0f;
    }

    public float getPipeLength(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastPipeLength, (float)this.pipeLength);
    }

    private void setPipeLength(float pipeLength) {
        this.lastPipeLength = this.pipeLength;
        this.pipeLength = pipeLength;
        this.syncToClient();
    }

    private void extendPipe() {
        float newPipeLength = this.isPipeExtended() ? 1.25f : this.pipeLength + 0.01f;
        this.setPipeLength(newPipeLength);
    }

    private void retractPipe() {
        float newPipeLength = this.isPipeRetracted() ? 0.0f : this.pipeLength - 0.01f;
        this.setPipeLength(newPipeLength);
    }

    private boolean isPipeExtended() {
        return this.pipeLength >= 1.25f;
    }

    private boolean isPipeRetracted() {
        return this.pipeLength <= 0.0f;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.getX(), (double)(this.getY() - 1), (double)this.getZ(), (double)(this.getX() + 1), (double)(this.getY() + 1), (double)(this.getZ() + 1));
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.currentCart instanceof FluidTransferHandler) {
            ((FluidTransferHandler)this.currentCart).setFilling(false);
        }
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        this.tankManager.pull(FluidTools.findNeighbors(this.f_58857_, this.m_58899_(), Predicates.notOfType(FluidLoaderBlockEntity.class), PULL_FROM), 0, 20);
    }

    @Override
    public Optional<AbstractMinecart> findCart() {
        return EntitySearcher.findMinecarts().box(builder -> builder.at(this.m_58899_().m_6625_(2)).raiseCeiling(1.0).inflate(-0.1f)).stream(this.f_58857_).findAny();
    }

    @Override
    protected void waitForReset(@Nullable AbstractMinecart cart) {
        if (this.isPipeRetracted()) {
            this.sendCart(cart);
        } else {
            this.retractPipe();
        }
    }

    @Override
    protected void onNoCart() {
        if (!this.isPipeRetracted()) {
            this.retractPipe();
        }
    }

    @Override
    protected void processCart(AbstractMinecart cart) {
        boolean needsPipe;
        SteamLocomotive locomotive;
        if (cart instanceof SteamLocomotive && !(locomotive = (SteamLocomotive)cart).isSafeToFill()) {
            this.retractPipe();
            return;
        }
        IFluidHandler tankCart = FluidLoaderBlockEntity.getFluidHandler(cart, Direction.UP);
        if (tankCart == null) {
            return;
        }
        boolean cartNeedsFilling = this.cartNeedsFilling(tankCart);
        boolean bl = needsPipe = cart != null && (double)this.m_58899_().m_123342_() - cart.m_20182_().m_7098_() > 1.0;
        if (cartNeedsFilling && needsPipe) {
            this.extendPipe();
        } else {
            this.retractPipe();
        }
        if (cartNeedsFilling && (!needsPipe || this.isPipeExtended())) {
            FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)tankCart, (IFluidHandler)this.tank, (int)((Integer)RailcraftConfig.SERVER.tankCartFluidTransferRate.get()), (boolean)true);
            this.setProcessing(!moved.isEmpty());
        } else {
            this.setProcessing(false);
        }
        if (this.isProcessing()) {
            this.setPowered(false);
        }
        if (cart instanceof FluidTransferHandler) {
            ((FluidTransferHandler)cart).setFilling(this.isProcessing());
        }
        if (!this.tank.getFluid().isEmpty() && tankCart.fill(this.tank.getFluid(), IFluidHandler.FluidAction.SIMULATE) == 0) {
            this.setResetTimer(200);
        }
    }

    private boolean cartNeedsFilling(IFluidHandler cartFluidHandler) {
        FluidStack fluidStack = this.tank.getFluid();
        return !fluidStack.isEmpty() && cartFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    @Override
    protected boolean hasWorkForCart(AbstractMinecart cart) {
        if (!this.isPipeRetracted()) {
            return true;
        }
        IFluidHandler cartFluidHandler = FluidLoaderBlockEntity.getFluidHandler(cart, Direction.UP);
        if (cartFluidHandler == null) {
            return false;
        }
        FluidStack fluid = this.getFluidHandled();
        if (fluid.isEmpty()) {
            return false;
        }
        switch (this.getRedstoneMode()) {
            case COMPLETE: {
                return cartFluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            case PARTIAL: {
                return !cartFluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE).isEmpty();
            }
        }
        return false;
    }

    @Override
    protected void setPowered(boolean powered) {
        if (this.isManualMode()) {
            powered = false;
        }
        super.setPowered(powered);
    }

    @Override
    protected FluidTools.ProcessType getProcessType() {
        return FluidTools.ProcessType.DRAIN_ONLY;
    }

    public void m_7651_() {
        super.m_7651_();
        this.resetPipeLength();
    }

    public void m_6339_() {
        super.m_6339_();
        this.resetPipeLength();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("pipeLength", this.pipeLength);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pipeLength = tag.m_128457_("pipeLength");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeFloat(this.pipeLength);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.setPipeLength(data.readFloat());
    }
}

