/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.ArrowDirection;
import mods.railcraft.api.track.SwitchActuator;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.track.actuator.SwitchTrackActuatorBlock;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class SwitchTrackBlockEntity
extends BlockEntity {
    private static final int SPRING_DURATION = 30;
    protected Set<UUID> lockingCarts = new HashSet<UUID>();
    protected Set<UUID> springingCarts = new HashSet<UUID>();
    protected Set<UUID> decidingCarts = new HashSet<UUID>();
    private byte sprung;
    private byte locked;
    @Nullable
    private RollingStock currentCart;
    @Nullable
    private UUID unresolvedCurrentCart;

    public SwitchTrackBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SwitchTrackBlockEntity blockEntity) {
        boolean switched;
        if (blockEntity.locked > 0) {
            blockEntity.locked = (byte)(blockEntity.locked - 1);
        }
        if (blockEntity.sprung > 0) {
            blockEntity.sprung = (byte)(blockEntity.sprung - 1);
        }
        if (blockEntity.locked == 0 && blockEntity.sprung == 0) {
            blockEntity.lockingCarts.clear();
            blockEntity.springingCarts.clear();
            blockEntity.decidingCarts.clear();
            blockEntity.currentCart = null;
        }
        blockEntity.updateSet(blockEntity.lockingCarts, blockEntity.getCartsAtLockEntrance(), blockEntity.springingCarts, blockEntity.decidingCarts);
        blockEntity.updateSet(blockEntity.springingCarts, blockEntity.getCartsAtSpringEntrance(), blockEntity.lockingCarts, blockEntity.decidingCarts);
        blockEntity.updateSet(blockEntity.decidingCarts, blockEntity.getCartsAtDecisionEntrance(), blockEntity.lockingCarts, blockEntity.springingCarts);
        List<AbstractMinecart> cartsOnTrack = EntitySearcher.findMinecarts().at(blockPos).inflate(-0.3f).list(blockEntity.m_58904_());
        Set uuidOnTrack = cartsOnTrack.stream().map(Entity::m_20148_).collect(Collectors.toSet());
        AbstractMinecart bestCart = blockEntity.getBestCartForVisualState(cartsOnTrack);
        boolean wasSwitched = SwitchTrackBlock.isSwitched(blockState);
        BlockPos actuatorBlockPos = blockEntity.getActuatorBlockPos();
        BlockState actuatorBlockState = blockEntity.f_58857_.m_8055_(actuatorBlockPos);
        boolean actuatorPresent = actuatorBlockState.m_204336_(RailcraftTags.Blocks.SWITCH_TRACK_ACTUATOR);
        boolean actuatorSwitched = actuatorPresent && SwitchTrackActuatorBlock.isSwitched(actuatorBlockState);
        boolean bl = switched = !blockEntity.isLocked() && (actuatorSwitched || blockEntity.isSprung());
        if (bestCart != null && uuidOnTrack.contains(bestCart.m_20148_())) {
            RollingStock rollingStock = RollingStock.getOrThrow(bestCart);
            if (blockEntity.shouldSwitchForCart(rollingStock)) {
                blockEntity.springTrack(rollingStock);
            } else {
                blockEntity.lockTrack(rollingStock);
            }
        }
        if (switched != wasSwitched) {
            blockEntity.f_58857_.m_46597_(blockEntity.m_58899_(), (BlockState)blockState.m_61124_((Property)SwitchTrackBlock.SWITCHED, (Comparable)Boolean.valueOf(switched)));
            if (actuatorPresent) {
                if (actuatorSwitched != switched) {
                    SwitchTrackActuatorBlock.setSwitched(actuatorBlockState, blockEntity.f_58857_, actuatorBlockPos, switched);
                }
                SwitchTrackActuatorBlock.updateArrowDirections(actuatorBlockState, blockEntity.f_58857_, actuatorBlockPos, blockEntity.getRedArrowDirection(), blockEntity.getWhiteArrowDirection());
            }
        }
    }

    protected abstract ArrowDirection getRedArrowDirection();

    protected abstract ArrowDirection getWhiteArrowDirection();

    @Nullable
    private AbstractMinecart getBestCartForVisualState(List<AbstractMinecart> cartsOnTrack) {
        if (!cartsOnTrack.isEmpty()) {
            return cartsOnTrack.get(0);
        }
        AbstractMinecart closestCart = null;
        ArrayList<UUID> allCarts = new ArrayList<UUID>();
        allCarts.addAll(this.lockingCarts);
        allCarts.addAll(this.springingCarts);
        allCarts.addAll(this.decidingCarts);
        for (UUID testCartUUID : allCarts) {
            double testDist;
            if (closestCart == null) {
                closestCart = MinecartUtil.getCartFromUUID(this.f_58857_, testCartUUID);
                continue;
            }
            double closestDist = SwitchTrackBlockEntity.crudeDistance(this.m_58899_(), closestCart);
            AbstractMinecart testCart = MinecartUtil.getCartFromUUID(this.f_58857_, testCartUUID);
            if (testCart == null || !((testDist = SwitchTrackBlockEntity.crudeDistance(this.m_58899_(), testCart)) < closestDist)) continue;
            closestCart = testCart;
        }
        return closestCart;
    }

    protected abstract List<UUID> getCartsAtLockEntrance();

    protected abstract List<UUID> getCartsAtSpringEntrance();

    protected abstract List<UUID> getCartsAtDecisionEntrance();

    public abstract Direction getActuatorDirection();

    public final BlockPos getActuatorBlockPos() {
        return this.m_58899_().m_121945_(this.getActuatorDirection());
    }

    public boolean shouldSwitchForCart(RollingStock rollingStock) {
        AbstractMinecart entity = rollingStock.entity();
        if (this.springingCarts.contains(entity.m_20148_())) {
            return true;
        }
        if (this.lockingCarts.contains(entity.m_20148_())) {
            return false;
        }
        boolean sameTrain = this.currentCart() != null && rollingStock.isSameTrainAs(this.currentCart());
        boolean shouldSwitch = false;
        BlockEntity actuatorBlockEntity = this.f_58857_.m_7702_(this.getActuatorBlockPos());
        if (actuatorBlockEntity instanceof SwitchActuator) {
            SwitchActuator switchActuator = (SwitchActuator)actuatorBlockEntity;
            shouldSwitch = switchActuator.shouldSwitch(rollingStock);
        }
        if (this.isSprung()) {
            return shouldSwitch || sameTrain;
        }
        if (this.isLocked()) {
            return shouldSwitch && !sameTrain;
        }
        return shouldSwitch;
    }

    @Nullable
    private RollingStock currentCart() {
        if (this.unresolvedCurrentCart != null) {
            Entity entity = ((ServerLevel)this.f_58857_).m_8791_(this.unresolvedCurrentCart);
            if (entity instanceof AbstractMinecart) {
                AbstractMinecart minecart = (AbstractMinecart)entity;
                this.currentCart = RollingStock.getOrThrow(minecart);
            }
            this.unresolvedCurrentCart = null;
        }
        return this.currentCart;
    }

    private void springTrack(RollingStock cartOnTrack) {
        this.sprung = (byte)30;
        this.locked = 0;
        this.currentCart = cartOnTrack;
    }

    private void lockTrack(RollingStock cartOnTrack) {
        this.locked = (byte)30;
        this.sprung = 0;
        this.currentCart = cartOnTrack;
    }

    public boolean isLocked() {
        return this.locked > 0;
    }

    public boolean isSprung() {
        return this.sprung > 0;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("sprung", this.sprung);
        tag.m_128344_("locked", this.locked);
        tag.m_128365_("springingCarts", (Tag)this.springingCarts.stream().map(NbtUtils::m_129226_).collect(Collectors.toCollection(ListTag::new)));
        tag.m_128365_("lockingCarts", (Tag)this.lockingCarts.stream().map(NbtUtils::m_129226_).collect(Collectors.toCollection(ListTag::new)));
        tag.m_128365_("decidingCarts", (Tag)this.decidingCarts.stream().map(NbtUtils::m_129226_).collect(Collectors.toCollection(ListTag::new)));
        if (this.currentCart != null) {
            tag.m_128362_("currentCart", this.currentCart.entity().m_20148_());
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sprung = tag.m_128445_("sprung");
        this.locked = tag.m_128445_("locked");
        this.springingCarts = tag.m_128437_("springingCarts", 11).stream().map(NbtUtils::m_129233_).collect(Collectors.toCollection(HashSet::new));
        this.lockingCarts = tag.m_128437_("lockingCarts", 11).stream().map(NbtUtils::m_129233_).collect(Collectors.toCollection(HashSet::new));
        this.decidingCarts = tag.m_128437_("decidingCarts", 11).stream().map(NbtUtils::m_129233_).collect(Collectors.toCollection(HashSet::new));
        this.unresolvedCurrentCart = tag.m_128403_("currentCart") ? tag.m_128342_("currentCart") : null;
    }

    private void updateSet(Set<UUID> setToUpdate, List<UUID> potentialUpdates, Set<UUID> reject1, Set<UUID> reject2) {
        for (UUID cartUUID : potentialUpdates) {
            reject1.remove(cartUUID);
            reject2.remove(cartUUID);
            setToUpdate.add(cartUUID);
        }
    }

    private static double crudeDistance(BlockPos pos, AbstractMinecart cart) {
        double cx = (double)pos.m_123341_() + 0.5;
        double cz = (double)pos.m_123343_() + 0.5;
        return Math.abs(cart.m_20185_() - cx) + Math.abs(cart.m_20189_() - cz);
    }
}

