/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class FluidItemHelper {
    public static boolean isContainer(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
    }

    public static boolean isFluidInContainer(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> !item.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()).isPresent();
    }

    public static boolean isFullContainer(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> {
            for (int i = 0; i < item.getTanks(); ++i) {
                if (item.getFluidInTank(i).getAmount() >= item.getTankCapacity(i)) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    public static boolean isEmptyContainer(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> {
            for (int i = 0; i < item.getTanks(); ++i) {
                if (item.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    public static boolean isRoomInContainer(ItemStack stack, Fluid fluid) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> item.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> {
            for (int i = 0; i < item.getTanks(); ++i) {
                if (item.getFluidInTank(i).getFluid().m_6212_(fluid)) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    private FluidItemHelper() {
    }
}

