/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class StandardTank
extends FluidTank {
    public static final int DEFAULT_COLOR = 0xFFFFFF;
    @Nullable
    protected Supplier<FluidStack> filter;
    @Nullable
    private Runnable changeCallback;
    private boolean disableDrain;
    private boolean disableFill;
    private List<Component> tooltip;
    @Nullable
    private BiFunction<FluidStack, IFluidHandler.FluidAction, FluidStack> fillProcessor;

    private StandardTank(int capacity) {
        super(capacity);
    }

    public StandardTank fillProcessor(Function<FluidStack, FluidStack> fillProcessor) {
        return this.fillProcessor((FluidStack resource, IFluidHandler.FluidAction action) -> action.execute() ? (FluidStack)fillProcessor.apply((FluidStack)resource) : resource);
    }

    public StandardTank fillProcessor(BiFunction<FluidStack, IFluidHandler.FluidAction, FluidStack> fillProcessor) {
        this.fillProcessor = fillProcessor;
        return this;
    }

    public StandardTank filter(TagKey<Fluid> tag) {
        return this.setValidator(fluidStack -> fluidStack.getFluid().m_205067_(tag));
    }

    public StandardTank filter(Fluid filter) {
        return this.filter(() -> filter);
    }

    public StandardTank filter(Supplier<? extends Fluid> filter) {
        this.filter = () -> new FluidStack((Fluid)filter.get(), 1);
        return this.setValidator(fluidStack -> this.filter.get().isFluidEqual(fluidStack));
    }

    public StandardTank setValidator(Predicate<FluidStack> validator) {
        super.setValidator(validator);
        return this;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fillProcessor != null) {
            resource = this.fillProcessor.apply(resource, action);
        }
        return this.disableFill ? 0 : super.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.disableDrain ? FluidStack.EMPTY : super.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.disableDrain ? FluidStack.EMPTY : super.drain(maxDrain, action);
    }

    public int internalFill(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.fill(resource, action);
    }

    public FluidStack internalDrain(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.drain(resource, action);
    }

    public FluidStack internalDrain(int maxDrain, IFluidHandler.FluidAction action) {
        return super.drain(maxDrain, action);
    }

    public StandardTank disableDrain() {
        this.disableDrain = true;
        return this;
    }

    public StandardTank disableFill() {
        this.disableFill = true;
        return this;
    }

    public StandardTank changeCallback(@Nullable Runnable changeCallback) {
        this.changeCallback = changeCallback;
        return this;
    }

    public boolean isFull() {
        return this.getFluid().getAmount() == this.getCapacity();
    }

    public int getRemainingSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public Fluid getFluidType() {
        return this.getFluid().getFluid();
    }

    public void setFluid(@Nullable FluidStack resource) {
        if (!this.isFluidValid(resource)) {
            return;
        }
        super.setFluid(resource);
        this.onContentsChanged();
    }

    protected void onContentsChanged() {
        this.refreshTooltip();
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    protected void refreshTooltip() {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        int amount = this.getFluidAmount();
        FluidStack fluidStack = this.getFluid();
        if (fluidStack.isEmpty() && this.filter != null) {
            fluidStack = this.filter.get();
        }
        if (!fluidStack.isEmpty()) {
            tooltip.add(this.getFluidNameToolTip(fluidStack));
        }
        tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())).m_130940_(ChatFormatting.GRAY));
        this.tooltip = Collections.unmodifiableList(tooltip);
    }

    protected Component getFluidNameToolTip(FluidStack fluidStack) {
        FluidType fluidType = fluidStack.getFluid().getFluidType();
        Rarity rarity = fluidType.getRarity();
        return fluidStack.getDisplayName().m_6881_().m_130938_(rarity.getStyleModifier());
    }

    public static StandardTank ofBuckets(int buckets) {
        return StandardTank.ofCapacity(buckets * 1000);
    }

    public static StandardTank ofCapacity(int capacity) {
        return new StandardTank(capacity);
    }
}

