/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.BlastFurnaceBlockEntity;
import mods.railcraft.world.module.CookingModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BlastFurnaceModule
extends CookingModule<BlastFurnaceRecipe, BlastFurnaceBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_SLAG = 3;
    private static final int FUEL_PER_TICK = 5;
    private final ContainerMapper fuelContainer = ContainerMapper.make(this, 1, 1);
    private final ContainerMapper outputContainer = ContainerMapper.make(this, 2, 1).ignoreItemChecks();
    private final ContainerMapper slagContainer = ContainerMapper.make(this, 3, 1).ignoreItemChecks();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper(this){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 || slot == 1) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0 || slot == 1) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    });
    private int burnTime;
    private int currentItemBurnTime;

    public BlastFurnaceModule(BlastFurnaceBlockEntity provider) {
        super(provider, 4, 0);
    }

    public ContainerManipulator<?> getFuelContainer() {
        return this.fuelContainer;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        this.setBurnTime(this.burnTime - 5);
    }

    @Override
    protected RecipeType<BlastFurnaceRecipe> getRecipeType() {
        return (RecipeType)RailcraftRecipeTypes.BLASTING.get();
    }

    @Override
    protected boolean doProcessStep() {
        this.loadFuel();
        return this.isBurning();
    }

    @Override
    protected boolean craftAndPush() {
        ItemStack output = ((BlastFurnaceRecipe)this.recipe).m_8043_(((BlastFurnaceBlockEntity)this.provider).level().m_9598_());
        if (!this.outputContainer.canFit(output)) {
            return false;
        }
        ItemStack nextSlag = ((Item)RailcraftItems.SLAG.get()).m_7968_();
        nextSlag.m_41764_(((BlastFurnaceRecipe)this.recipe).getSlagOutput());
        if (!this.slagContainer.canFit(nextSlag)) {
            return false;
        }
        this.outputContainer.insert(output);
        this.slagContainer.insert(nextSlag);
        this.m_7407_(0, 1);
        this.setProgress(0);
        return true;
    }

    private int getItemBurnTime(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack, null);
    }

    private void loadFuel() {
        ItemStack fuel;
        if (this.burnTime > 10 || (fuel = this.m_8020_(1)).m_41619_()) {
            return;
        }
        int itemBurnTime = this.getItemBurnTime(fuel);
        if (itemBurnTime <= 0) {
            return;
        }
        this.currentItemBurnTime = itemBurnTime + this.burnTime;
        this.setBurnTime(this.currentItemBurnTime);
        fuel.m_41774_(1);
        this.m_6836_(1, fuel.m_41619_() ? ItemStack.f_41583_ : fuel);
    }

    public void setBurnTime(int burnTime) {
        burnTime = Math.max(0, burnTime);
        boolean wasBurning = this.isBurning();
        this.burnTime = burnTime;
        if (wasBurning != this.isBurning()) {
            ((BlastFurnaceBlockEntity)this.provider).syncToClient();
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnProgressScaled(int scale) {
        if (this.burnTime <= 0 || this.currentItemBurnTime <= 0) {
            return 0;
        }
        return Mth.m_14045_((int)(this.burnTime * scale / this.currentItemBurnTime), (int)0, (int)scale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean m_7013_(int slot, ItemStack itemStack) {
        switch (slot) {
            case 0: {
                if (!this.getRecipeFor(itemStack).isPresent()) return false;
                break;
            }
            case 1: {
                if (!this.isFuel(itemStack)) return false;
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.m_7013_(slot, itemStack)) return false;
        return true;
    }

    public boolean isFuel(ItemStack itemStack) {
        return this.getItemBurnTime(itemStack) > 0;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public void invalidItemHandler() {
        this.itemHandler.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("currentItemBurnTime", this.currentItemBurnTime);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.burnTime = tag.m_128451_("burnTime");
        this.currentItemBurnTime = tag.m_128451_("currentItemBurnTime");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130130_(this.burnTime);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.setBurnTime(in.m_130242_());
    }
}

