/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.ChargeModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SteamTurbineModule
extends ChargeModule<SteamTurbineBlockEntity> {
    private static final int ROTOR_DAMAGE_CHANCE = 200;
    public static final int CHARGE_OUTPUT = 225;
    private static final int STEAM_USAGE = 360;
    public static final int TANK_STEAM = 0;
    public static final int TANK_WATER = 1;
    private final StandardTank steamTank;
    private final StandardTank waterTank;
    private final AdvancedContainer rotorContainer = new AdvancedContainer(1);
    private float operatingRatio;
    private int energy;
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> new FluidHandler());

    public SteamTurbineModule(SteamTurbineBlockEntity provider, Charge network) {
        super(provider, network);
        this.rotorContainer.listener(this.provider);
        this.steamTank = StandardTank.ofBuckets(4).filter(RailcraftTags.Fluids.STEAM).disableDrain().changeCallback(() -> ((SteamTurbineBlockEntity)provider).m_6596_());
        this.waterTank = StandardTank.ofBuckets(4).filter((TagKey<Fluid>)FluidTags.f_13131_).disableFill().changeCallback(() -> ((SteamTurbineBlockEntity)provider).m_6596_());
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void serverTick() {
        ItemStack rotorStack;
        FluidStack steam;
        super.serverTick();
        boolean addedEnergy = false;
        if (this.energy < 225 && (steam = this.steamTank.internalDrain(360, IFluidHandler.FluidAction.SIMULATE)).getAmount() >= 360 && (rotorStack = this.rotorContainer.m_8020_(0)).m_150930_((Item)RailcraftItems.TURBINE_ROTOR.get())) {
            addedEnergy = true;
            this.energy += 225;
            this.steamTank.internalDrain(360, IFluidHandler.FluidAction.EXECUTE);
            this.waterTank.internalFill(new FluidStack((Fluid)Fluids.f_76193_, 2), IFluidHandler.FluidAction.EXECUTE);
            this.rotorContainer.m_6836_(0, this.useRotor(rotorStack));
        }
        float thisTick = addedEnergy ? 1.0f : 0.0f;
        this.operatingRatio = (thisTick - this.operatingRatio) * 0.05f + this.operatingRatio;
        ChargeStorage chargeStorage = this.storage().get();
        if (!chargeStorage.isFull()) {
            chargeStorage.receiveEnergy(this.energy, false);
            this.energy = 0;
        }
    }

    public float getOperatingRatio() {
        return this.operatingRatio;
    }

    public Container getRotorContainer() {
        return this.rotorContainer;
    }

    public boolean needsMaintenance() {
        ItemStack rotorStack = this.rotorContainer.m_8020_(0);
        return rotorStack.m_41619_() || !rotorStack.m_150930_((Item)RailcraftItems.TURBINE_ROTOR.get()) || (float)rotorStack.m_41773_() / (float)rotorStack.m_41776_() > 0.75f;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("steamTank", (Tag)this.steamTank.writeToNBT(new CompoundTag()));
        tag.m_128365_("waterTank", (Tag)this.waterTank.writeToNBT(new CompoundTag()));
        tag.m_128365_("rotorContainer", (Tag)this.rotorContainer.m_7927_());
        tag.m_128405_("energy", this.energy);
        tag.m_128350_("operatingRatio", this.operatingRatio);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.steamTank.readFromNBT(tag.m_128469_("steamTank"));
        this.waterTank.readFromNBT(tag.m_128469_("waterTank"));
        this.rotorContainer.m_7797_(tag.m_128437_("rotorContainer", 10));
        this.energy = tag.m_128451_("energy");
        this.operatingRatio = tag.m_128457_("operatingRatio");
    }

    public ItemStack useRotor(ItemStack stack) {
        RandomSource random = ((SteamTurbineBlockEntity)this.provider).level().m_213780_();
        return random.m_188503_(200) == 0 && stack.m_220157_(1, random, null) ? ItemStack.f_41583_ : stack;
    }

    public class FluidHandler
    implements IFluidHandler {
        public int getTanks() {
            return 2;
        }

        private IFluidTank getTank(int tank) {
            return tank == 0 ? SteamTurbineModule.this.steamTank : SteamTurbineModule.this.waterTank;
        }

        public FluidStack getFluidInTank(int tank) {
            return this.getTank(tank).getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.getTank(tank).getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return this.getTank(tank).isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return SteamTurbineModule.this.steamTank.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return SteamTurbineModule.this.waterTank.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return SteamTurbineModule.this.waterTank.drain(maxDrain, action);
        }
    }
}

