/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.signal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.railcraft.world.signal.SimpleTokenRing;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class TokenRingManager
extends SavedData {
    private static final String DATA_TAG = "railcraft.tokens";
    private final ServerLevel level;
    private final Map<UUID, SimpleTokenRing> tokenRings = new HashMap<UUID, SimpleTokenRing>();
    private int clock;

    public TokenRingManager(ServerLevel level) {
        this.level = level;
    }

    private void load(CompoundTag data) {
        ListTag tokenRingList = data.m_128437_("tokenRings", 10);
        for (int i = 0; i < tokenRingList.size(); ++i) {
            CompoundTag entry = tokenRingList.m_128728_(i);
            UUID id = entry.m_128342_("id");
            SimpleTokenRing tokenRing = new SimpleTokenRing(this.level, this, id);
            this.tokenRings.put(id, tokenRing);
            ListTag signalList = entry.m_128437_("signals", 10);
            Set<BlockPos> signalPositions = signalList.stream().map(CompoundTag.class::cast).map(NbtUtils::m_129239_).collect(Collectors.toSet());
            tokenRing.loadSignals(signalPositions);
            ListTag cartList = entry.m_128437_("carts", 10);
            Set<UUID> carts = cartList.stream().map(CompoundTag.class::cast).map(signal -> signal.m_128342_("cart")).collect(Collectors.toSet());
            tokenRing.loadCarts(carts);
        }
    }

    public CompoundTag m_7176_(CompoundTag data) {
        ListTag tokenRingList = new ListTag();
        for (SimpleTokenRing tokenRing : this.tokenRings.values()) {
            CompoundTag tokenData = new CompoundTag();
            tokenData.m_128362_("id", tokenRing.getId());
            ListTag signalList = new ListTag();
            for (BlockPos pos : tokenRing.peers()) {
                signalList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            tokenData.m_128365_("signals", (Tag)signalList);
            ListTag cartList = new ListTag();
            for (UUID uuid : tokenRing.getTrackedCarts()) {
                CompoundTag cart = new CompoundTag();
                cart.m_128362_("cart", uuid);
                cartList.add((Object)cart);
            }
            tokenData.m_128365_("carts", (Tag)cartList);
            tokenRingList.add((Object)tokenData);
        }
        data.m_128365_("tokenRings", (Tag)tokenRingList);
        return data;
    }

    public void tick(ServerLevel level) {
        ++this.clock;
        if (this.clock >= 32) {
            this.clock = 0;
            if (this.tokenRings.entrySet().removeIf(e -> ((SimpleTokenRing)e.getValue()).isOrphaned(level))) {
                this.m_77762_();
            }
            this.tokenRings.values().forEach(SimpleTokenRing::tick);
        }
    }

    public SimpleTokenRing getTokenRingNetwork(UUID id, BlockPos origin) {
        return this.tokenRings.computeIfAbsent(id, __ -> new SimpleTokenRing(this.level, this, id, origin));
    }

    public Collection<SimpleTokenRing> getTokenRings() {
        return this.tokenRings.values();
    }

    public static TokenRingManager get(ServerLevel level) {
        return (TokenRingManager)level.m_8895_().m_164861_(tag -> {
            TokenRingManager manager = new TokenRingManager(level);
            manager.load((CompoundTag)tag);
            return manager;
        }, () -> new TokenRingManager(level), DATA_TAG);
    }
}

