/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.compat.jei;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.compat.jei.ChiselingJEIPlugin;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselingRecipeCategory
implements IRecipeCategory<ChiselingRecipe> {
    private final IDrawable backgrounds;
    private final IDrawable icon;

    public ChiselingRecipeCategory(IGuiHelper guiHelper) {
        this.backgrounds = guiHelper.createDrawable(new ResourceLocation("rechiseled", "textures/screen/jei_category_background.png"), 0, 0, 174, 72);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Rechiseled.chisel));
    }

    public RecipeType<ChiselingRecipe> getRecipeType() {
        return ChiselingJEIPlugin.CHISELING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"rechiseled.jei_category.title").get();
    }

    public IDrawable getBackground() {
        return this.backgrounds;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, ChiselingRecipe recipe, IFocusGroup focusGroup) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList outputs = new ArrayList();
        for (ChiselingEntry entry : recipe.getEntries()) {
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            if (entry.hasRegularItem()) {
                inputs.add(new ItemStack((ItemLike)entry.getRegularItem()));
                output.add(new ItemStack((ItemLike)entry.getRegularItem()));
            }
            if (entry.hasConnectingItem()) {
                inputs.add(new ItemStack((ItemLike)entry.getConnectingItem()));
                output.add(new ItemStack((ItemLike)entry.getConnectingItem()));
            }
            outputs.add(output);
        }
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 28).addItemStacks(inputs);
        for (int i = 0; i < outputs.size(); ++i) {
            int x = 49 + 18 * (i % 7);
            int y = 1 + 18 * (i / 7);
            recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStacks((List)outputs.get(i));
        }
    }
}

