/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.capability;

import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.common.energy.EnergyContainerItemWrapper;
import cofh.lib.util.Utils;
import cofh.redstonearsenal.common.capability.CapabilityFluxShielding;
import cofh.redstonearsenal.common.capability.IFluxShieldedItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class FluxShieldedEnergyItemWrapper
extends EnergyContainerItemWrapper
implements IFluxShieldedItem {
    private final LazyOptional<IFluxShieldedItem> holder = LazyOptional.of(() -> this);
    protected final ItemStack shieldedItem;
    protected final int COOLDOWN = 600;
    protected int energyPerUse;
    protected long availableTime = -1L;

    public FluxShieldedEnergyItemWrapper(ItemStack shieldedItemContainer, int energyPerUse) {
        super(shieldedItemContainer, (IEnergyContainerItem)shieldedItemContainer.m_41720_(), ((IEnergyContainerItem)shieldedItemContainer.m_41720_()).getEnergyCapability());
        this.shieldedItem = shieldedItemContainer;
        this.energyPerUse = energyPerUse;
    }

    @Override
    public int currCharges(LivingEntity entity) {
        CompoundTag nbt = this.shieldedItem.m_41784_();
        if (this.energyPerUse > 0 && this.getEnergyStored() < this.energyPerUse) {
            return 0;
        }
        if (this.availableTime <= -1L) {
            if (!nbt.m_128441_("FluxShield")) {
                this.availableTime = 0L;
                return 1;
            }
            this.availableTime = nbt.m_128454_("FluxShield");
        }
        return entity.f_19853_.m_46467_() >= this.availableTime ? 1 : 0;
    }

    @Override
    public int maxCharges(LivingEntity entity) {
        return 1;
    }

    @Override
    public boolean useCharge(LivingEntity entity) {
        if (this.currCharges(entity) < 1 || this.energyPerUse > 0 && this.getEnergyStored() >= this.energyPerUse && this.extractEnergy(this.energyPerUse, Utils.isCreativePlayer((Entity)entity)) != this.energyPerUse) {
            return false;
        }
        this.availableTime = entity.f_19853_.m_46467_() + 600L;
        this.shieldedItem.m_41784_().m_128356_("FluxShield", this.availableTime);
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY) {
            return CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }
}

