/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.cache.listener;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.network.grid.GridItemDeltaMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemUpdateMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemGridStorageCacheListener
implements IStorageCacheListener<ItemStack> {
    private final ServerPlayer player;
    private final INetwork network;

    public ItemGridStorageCacheListener(ServerPlayer player, INetwork network) {
        this.player = player;
        this.network = network;
    }

    @Override
    public void onAttached() {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridItemUpdateMessage(this.network, this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (Player)this.player)));
    }

    @Override
    public void onInvalidated() {
    }

    @Override
    public void onChanged(StackListResult<ItemStack> delta) {
        ArrayList<StackListResult<ItemStack>> deltas = new ArrayList<StackListResult<ItemStack>>();
        deltas.add(delta);
        this.onChangedBulk((List<StackListResult<ItemStack>>)deltas);
    }

    @Override
    public void onChangedBulk(List<StackListResult<ItemStack>> deltas) {
        RS.NETWORK_HANDLER.sendTo(this.player, new GridItemDeltaMessage(this.network, deltas));
    }
}

