/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.util;

import com.google.common.collect.ArrayListMultimap;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackList
implements IStackList<ItemStack> {
    private final ArrayListMultimap<Item, StackListEntry<ItemStack>> stacks = ArrayListMultimap.create();
    private final Map<UUID, ItemStack> index = new HashMap<UUID, ItemStack>();

    public ItemStackList() {
    }

    public ItemStackList(Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            this.add(stack);
        }
    }

    @Override
    public StackListResult<ItemStack> add(@Nonnull ItemStack stack, int size) {
        if (stack.m_41619_() || size <= 0) {
            throw new IllegalArgumentException("Cannot accept empty stack");
        }
        for (StackListEntry entry : this.stacks.get((Object)stack.m_41720_())) {
            ItemStack otherStack = (ItemStack)entry.getStack();
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if ((long)otherStack.m_41613_() + (long)size > Integer.MAX_VALUE) {
                otherStack.m_41764_(Integer.MAX_VALUE);
            } else {
                otherStack.m_41769_(size);
            }
            return new StackListResult<ItemStack>(otherStack, entry.getId(), size);
        }
        StackListEntry<ItemStack> newEntry = new StackListEntry<ItemStack>(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
        this.stacks.put((Object)stack.m_41720_(), newEntry);
        this.index.put(newEntry.getId(), newEntry.getStack());
        return new StackListResult<ItemStack>(newEntry.getStack(), newEntry.getId(), size);
    }

    @Override
    public StackListResult<ItemStack> add(@Nonnull ItemStack stack) {
        return this.add(stack, stack.m_41613_());
    }

    @Override
    public StackListResult<ItemStack> remove(@Nonnull ItemStack stack, int size) {
        for (StackListEntry entry : this.stacks.get((Object)stack.m_41720_())) {
            ItemStack otherStack = (ItemStack)entry.getStack();
            if (!API.instance().getComparer().isEqualNoQuantity(otherStack, stack)) continue;
            if (otherStack.m_41613_() - size <= 0) {
                this.stacks.remove((Object)otherStack.m_41720_(), (Object)entry);
                this.index.remove(entry.getId());
                return new StackListResult<ItemStack>(otherStack, entry.getId(), -otherStack.m_41613_());
            }
            otherStack.m_41774_(size);
            return new StackListResult<ItemStack>(otherStack, entry.getId(), -size);
        }
        return null;
    }

    @Override
    public StackListResult<ItemStack> remove(@Nonnull ItemStack stack) {
        return this.remove(stack, stack.m_41613_());
    }

    @Override
    public int getCount(@Nonnull ItemStack stack, int flags) {
        ItemStack found = this.get(stack, flags);
        if (found == null) {
            return 0;
        }
        return found.m_41613_();
    }

    @Override
    @Nullable
    public ItemStack get(@Nonnull ItemStack stack, int flags) {
        for (StackListEntry entry : this.stacks.get((Object)stack.m_41720_())) {
            ItemStack otherStack = (ItemStack)entry.getStack();
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return otherStack;
        }
        return null;
    }

    @Override
    @Nullable
    public StackListEntry<ItemStack> getEntry(@Nonnull ItemStack stack, int flags) {
        for (StackListEntry entry : this.stacks.get((Object)stack.m_41720_())) {
            ItemStack otherStack = (ItemStack)entry.getStack();
            if (!API.instance().getComparer().isEqual(otherStack, stack, flags)) continue;
            return entry;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack get(UUID id) {
        return this.index.get(id);
    }

    @Override
    public void clear() {
        this.stacks.clear();
        this.index.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<StackListEntry<ItemStack>> getStacks() {
        return this.stacks.values();
    }

    @Override
    @Nonnull
    public Collection<StackListEntry<ItemStack>> getStacks(@Nonnull ItemStack stack) {
        return this.stacks.get((Object)stack.m_41720_());
    }

    @Override
    @Nonnull
    public IStackList<ItemStack> copy() {
        ItemStackList list = new ItemStackList();
        for (StackListEntry entry : this.stacks.values()) {
            ItemStack newStack = ((ItemStack)entry.getStack()).m_41777_();
            list.stacks.put((Object)((ItemStack)entry.getStack()).m_41720_(), new StackListEntry<ItemStack>(entry.getId(), newStack));
            list.index.put(entry.getId(), newStack);
        }
        return list;
    }

    @Override
    public int size() {
        return this.stacks.size();
    }
}

