/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.hud;

import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackCountPane;
import reliquary.reference.Colors;
import reliquary.util.InventoryHelper;

public class ChargePane
extends Component {
    private final Item mainItem;
    private final ItemStackCountPane chargeablePane;
    private final Function<ItemStack, Integer> getCount;

    public ChargePane(Item mainItem, ItemStack chargeItem, Function<ItemStack, Integer> getCount) {
        this(mainItem, chargeItem, getCount, Colors.get("FFFFFF"));
    }

    public ChargePane(Item mainItem, ItemStack chargeItem, Function<ItemStack, Integer> getCount, int textColor) {
        this.mainItem = mainItem;
        this.getCount = getCount;
        this.chargeablePane = new ItemStackCountPane(chargeItem, 0, textColor);
    }

    @Override
    public int getHeightInternal() {
        return this.chargeablePane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.chargeablePane.getWidth();
    }

    @Override
    public int getPadding() {
        return this.chargeablePane.getPadding();
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack itemStack = InventoryHelper.getCorrectItemFromEitherHand((Player)player, this.mainItem);
        if (itemStack.m_41619_()) {
            return;
        }
        this.chargeablePane.setCount(this.getCount.apply(itemStack));
        this.chargeablePane.render(guiGraphics, x, y);
    }
}

