/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.lootmanager;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSMainModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.PlatformHooks;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class StructureModdedLootImporter {
    public static final Map<ResourceLocation, ResourceLocation> TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    private static Set<ResourceLocation> BLACKLISTED_LOOTTABLES;

    public static Map<ResourceLocation, ResourceLocation> createMap() {
        HashMap<ResourceLocation, ResourceLocation> tableMap = new HashMap<ResourceLocation, ResourceLocation>();
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/cities/nether"), new ResourceLocation("minecraft:chests/bastion_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/cities/overworld"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ancient_cities/ocean"), new ResourceLocation("minecraft:chests/ancient_city"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ancient_cities/ocean_ice_box"), new ResourceLocation("minecraft:chests/ancient_city_ice_box"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ancient_cities/nether"), new ResourceLocation("minecraft:chests/ancient_city"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ancient_cities/nether_magma_box"), new ResourceLocation("minecraft:chests/ancient_city_ice_box"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ancient_cities/end"), new ResourceLocation("minecraft:chests/ancient_city"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ancient_cities/end_spawner_box"), new ResourceLocation("minecraft:chests/ancient_city_ice_box"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/treasure"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/bridge"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/other"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/badlands"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/dark_forest"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/deep"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/desert"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/icy"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/jungle"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/mushroom"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/nether"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/ocean"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/snow"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/swamp"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/dungeons/end"), new ResourceLocation("minecraft:chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortresses/jungle_center"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortresses/jungle_hallway"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortresses/jungle_shrine"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/grassy"), new ResourceLocation("minecraft:chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/stone"), new ResourceLocation("minecraft:chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/mangrove"), new ResourceLocation("minecraft:chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/mushroom"), new ResourceLocation("minecraft:chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/birch"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/desert"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/jungle"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/mangrove"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/oak"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/savanna"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/snowy"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mansions/taiga"), new ResourceLocation("minecraft:chests/woodland_mansion"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/birch"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/crimson"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/dark_forest"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/desert"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/end"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/icy"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/jungle"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/nether"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/ocean"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/savanna"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/stone"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/swamp"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/taiga"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/warped"), new ResourceLocation("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/badlands"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/birch"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/crimson"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/desert"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/giant_tree_taiga"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/icy"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/jungle"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/mangrove"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/nether_brick"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/oak"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/snowy"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/taiga"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/warped"), new ResourceLocation("minecraft:chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/outposts/end"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/dark_forest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/end"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/flower_forest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/giant_tree_taiga"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/icy"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/jungle"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/mushroom"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/snowy"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/badlands"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/end"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/nether"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/ocean"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/pyramids/dark_forest"), new ResourceLocation("minecraft:chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruined_portals/end/large_portal"), new ResourceLocation("minecraft:chests/ruined_portal"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruined_portals/end/small_portal"), new ResourceLocation("minecraft:chests/ruined_portal"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_hot/large"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_hot/small"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_warm/large"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_warm/small"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_cold/large"), new ResourceLocation("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_cold/small"), new ResourceLocation("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_icy/large"), new ResourceLocation("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/land_icy/small"), new ResourceLocation("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/ruins/nether"), new ResourceLocation("minecraft:chests/bastion_other"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/crimson/map"), new ResourceLocation("minecraft:chests/shipwreck_map"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/crimson/supply"), new ResourceLocation("minecraft:chests/shipwreck_supply"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/crimson/treasure"), new ResourceLocation("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/end/map"), new ResourceLocation("minecraft:chests/shipwreck_map"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/end/supply"), new ResourceLocation("minecraft:chests/shipwreck_supply"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/end/treasure"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/warped/map"), new ResourceLocation("minecraft:chests/shipwreck_map"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/warped/supply"), new ResourceLocation("minecraft:chests/shipwreck_supply"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/warped/treasure"), new ResourceLocation("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/nether_bricks/treasure"), new ResourceLocation("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/strongholds/end_storage_room"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/strongholds/end_hallway"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "shulker_boxes/strongholds/end_library"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/strongholds/nether_storage_room"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/strongholds/nether_hallway"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/strongholds/nether_library"), new ResourceLocation("minecraft:chests/stronghold_library"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/basalt"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/crimson"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/soul"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/warped"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/wasteland"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/taiga"), new ResourceLocation("minecraft:chests/jungle_temple"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/ocean"), new ResourceLocation("minecraft:chests/jungle_temple"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/temples/warped"), new ResourceLocation("minecraft:chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/temples/basalt"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/temples/crimson"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/temples/soul"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/temples/warped"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/temples/wasteland"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "dispensers/temples/taiga"), new ResourceLocation("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/badlands_house"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/bamboo_house"), new ResourceLocation("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/birch_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/cherry_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/dark_forest_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/giant_taiga_house"), new ResourceLocation("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/jungle_house"), new ResourceLocation("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/mountains_house"), new ResourceLocation("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/mushroom_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/oak_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/ocean_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/ocean_cartographer"), new ResourceLocation("minecraft:chests/village/village_cartographer"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/swamp_house"), new ResourceLocation("minecraft:chests/village/village_plains_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/crimson_cartographer"), new ResourceLocation("minecraft:chests/village/village_cartographer"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/crimson_fisher"), new ResourceLocation("minecraft:chests/village/village_fisher"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/crimson_tannery"), new ResourceLocation("minecraft:chests/village/village_tannery"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/crimson_weaponsmith"), new ResourceLocation("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/crimson_house"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/warped_cartographer"), new ResourceLocation("minecraft:chests/village/village_cartographer"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/warped_fisher"), new ResourceLocation("minecraft:chests/village/village_fisher"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/warped_tannery"), new ResourceLocation("minecraft:chests/village/village_tannery"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/warped_weaponsmith"), new ResourceLocation("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/villages/warped_house"), new ResourceLocation("minecraft:chests/village/village_desert_house"));
        if (PlatformHooks.isModLoaded("betterstrongholds")) {
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/armoury"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/common"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/crypt"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/grand_library"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/library_md"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/mess"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/prison_lg"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/trap"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/treasure"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/common"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/mess"), new ResourceLocation("minecraft:chests/stronghold_crossing"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/armoury"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/crypt"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/prison_lg"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/trap"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/treasure"), new ResourceLocation("minecraft:chests/stronghold_corridor"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/grand_library"), new ResourceLocation("minecraft:chests/stronghold_library"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/nether/library_md"), new ResourceLocation("minecraft:chests/stronghold_library"));
        }
        return tableMap;
    }

    public static boolean isInBlacklist(ResourceLocation lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = RSMainModdedLootConfig.blacklistedRSLoottablesFromImportingModdedItems.trim();
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.isEmpty() ? new HashSet<ResourceLocation>() : Arrays.stream(cleanedBlacklist.split(",")).map(String::trim).map(ResourceLocation::new).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        boolean invalidLootTableFound = false;
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : TABLE_IMPORTS.entrySet()) {
            if (entry.getKey().m_135827_().equals("betterstrongholds") || !GeneralUtils.isInvalidLootTableFound(minecraftServer, entry)) continue;
            invalidLootTableFound = true;
        }
        if (GeneralUtils.isMissingLootImporting(minecraftServer, TABLE_IMPORTS.keySet())) {
            invalidLootTableFound = true;
        }
        if (invalidLootTableFound) {
            RepurposedStructures.LOGGER.error("Unknown import/target loot tables found for Repurposed Structures. See above logs and report to TelepathicGrunt please.");
        }
    }
}

