/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.forge.biomemodifiers;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.forge.RSBiomeModifiers;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record AdditionsTemperatureModifier(HolderSet<Biome> biomes, Holder<PlacedFeature> feature, GenerationStep.Decoration step, TEMPERATURE_RANGE temperatureRange) implements BiomeModifier
{
    public static Codec<AdditionsTemperatureModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(AdditionsTemperatureModifier::biomes), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(AdditionsTemperatureModifier::feature), (App)GenerationStep.Decoration.f_224188_.fieldOf("step").forGetter(AdditionsTemperatureModifier::step), (App)StringRepresentable.m_216439_(TEMPERATURE_RANGE::values).fieldOf("biome_temperature_allowed").stable().forGetter(AdditionsTemperatureModifier::temperatureRange)).apply((Applicative)builder, AdditionsTemperatureModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
            Biome rawBiome = (Biome)biome.get();
            String biomeNamespace = ((ResourceKey)biome.m_203543_().get()).m_135782_().m_135827_();
            String biomePath = ((ResourceKey)biome.m_203543_().get()).m_135782_().m_135815_();
            switch (this.temperatureRange) {
                case WARM: {
                    if ((!this.nameMatch(biomePath, "hot", "tropic", "warm") || this.nameMatch(biomePath, "lukewarm")) && (this.nameExactMatch(biomeNamespace, "minecraft") || !(rawBiome.getModifiedClimateSettings().f_47681_() >= 1.5f))) break;
                    builder.getGenerationSettings().m_255419_(this.step, this.feature);
                    break;
                }
                case LUKEWARM: {
                    if (!this.nameMatch(biomePath, "lukewarm") && (this.nameExactMatch(biomeNamespace, "minecraft") || !(rawBiome.getModifiedClimateSettings().f_47681_() >= 0.9f) || !(rawBiome.getModifiedClimateSettings().f_47681_() < 1.5f))) break;
                    builder.getGenerationSettings().m_255419_(this.step, this.feature);
                    break;
                }
                case NEUTRAL: {
                    if (this.nameMatch(biomePath, "hot", "tropic", "warm", "cold", "chilly", "frozen", "snow", "ice", "frost") && (this.nameExactMatch(biomeNamespace, "minecraft") || !(rawBiome.getModifiedClimateSettings().f_47681_() >= 0.5f) || !(rawBiome.getModifiedClimateSettings().f_47681_() < 0.9f))) break;
                    builder.getGenerationSettings().m_255419_(this.step, this.feature);
                    break;
                }
                case COLD: {
                    if (!this.nameMatch(biomePath, "cold", "chilly") && (this.nameExactMatch(biomeNamespace, "minecraft") || !(rawBiome.getModifiedClimateSettings().f_47681_() >= 0.0f) || !(rawBiome.getModifiedClimateSettings().f_47681_() < 0.5f))) break;
                    builder.getGenerationSettings().m_255419_(this.step, this.feature);
                    break;
                }
                case FROZEN: {
                    if (!this.nameMatch(biomePath, "frozen", "snow", "ice", "frost") && (this.nameExactMatch(biomeNamespace, "minecraft") || !(rawBiome.getModifiedClimateSettings().f_47681_() < 0.0f))) break;
                    builder.getGenerationSettings().m_255419_(this.step, this.feature);
                }
            }
        }
    }

    private boolean nameMatch(String biomeName, String ... targetMatch) {
        return Arrays.stream(targetMatch).anyMatch(biomeName::contains);
    }

    private boolean nameExactMatch(String biomeName, String ... targetMatch) {
        return Arrays.asList(targetMatch).contains(biomeName);
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)RSBiomeModifiers.ADDITIONS_TEMPERATURE_MODIFIER.get();
    }

    public static enum TEMPERATURE_RANGE implements StringRepresentable
    {
        WARM("WARM"),
        LUKEWARM("LUKEWARM"),
        NEUTRAL("NEUTRAL"),
        COLD("COLD"),
        FROZEN("FROZEN");

        private final String name;
        private static final Map<String, TEMPERATURE_RANGE> BY_NAME;

        private TEMPERATURE_RANGE(String name) {
            this.name = name;
        }

        public static TEMPERATURE_RANGE byName(String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
                TEMPERATURE_RANGE[] var1;
                for (TEMPERATURE_RANGE type : var1 = TEMPERATURE_RANGE.values()) {
                    hashMap.put(type.name, type);
                }
            });
        }
    }
}

