/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionStructurePiece;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class MansionStructure
extends Structure {
    public static final Codec<MansionStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MansionStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("mansion_type").forGetter(structure -> structure.mansionType), (App)BlockState.f_61039_.fieldOf("foundation_block").forGetter(structure -> structure.foundationBlock), (App)Codec.BOOL.fieldOf("pillar_only_to_land").orElse((Object)true).forGetter(structure -> structure.pillarOnlyToLand), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius)).apply((Applicative)instance, MansionStructure::new));
    public final String mansionType;
    public final BlockState foundationBlock;
    public final boolean pillarOnlyToLand;
    public final Optional<Integer> biomeRadius;

    public MansionStructure(Structure.StructureSettings config, String mansionType, BlockState foundationBlock, boolean pillarOnlyToLand, Optional<Integer> biomeRadius) {
        super(config);
        this.mansionType = mansionType.toLowerCase(Locale.ROOT);
        this.foundationBlock = foundationBlock;
        this.pillarOnlyToLand = pillarOnlyToLand;
        this.biomeRadius = biomeRadius;
    }

    protected boolean extraSpawningChecks(Structure.GenerationContext context, BlockPos blockPos) {
        ChunkPos chunkPos = context.f_226628_();
        if (this.biomeRadius.isPresent() && !(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            int validBiomeRange = this.biomeRadius.get();
            for (int curChunkX = chunkPos.f_45578_ - validBiomeRange; curChunkX <= chunkPos.f_45578_ + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - validBiomeRange; curChunkZ <= chunkPos.f_45579_ + validBiomeRange; ++curChunkZ) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), QuartPos.m_175400_((int)blockPos.m_123342_()), QuartPos.m_175404_((int)curChunkZ), context.f_226624_().m_224579_());
                    if (context.f_226630_().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        Rotation blockRotation = Rotation.m_221990_((RandomSource)random);
        int xOffset = 5;
        int zOffset = 5;
        if (blockRotation == Rotation.CLOCKWISE_90) {
            xOffset = -5;
        } else if (blockRotation == Rotation.CLOCKWISE_180) {
            xOffset = -5;
            zOffset = -5;
        } else if (blockRotation == Rotation.COUNTERCLOCKWISE_90) {
            zOffset = -5;
        }
        int centerX = chunkPos.m_151390_();
        int centerZ = chunkPos.m_151393_();
        int firstHeight = context.f_226622_().m_223235_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        int secondHeight = context.f_226622_().m_223235_(centerX, centerZ + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        int thirdHeight = context.f_226622_().m_223235_(centerX + xOffset, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        int forthheight = context.f_226622_().m_223235_(centerX + xOffset, centerZ + zOffset, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        int finalheight = Math.min(Math.min(firstHeight, secondHeight), Math.min(thirdHeight, forthheight));
        if (finalheight <= context.f_226622_().m_142062_()) {
            return Optional.empty();
        }
        if (!this.extraSpawningChecks(context, chunkPos.m_151394_(finalheight))) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(new BlockPos(centerX, finalheight + 1, centerZ), structurePiecesBuilder -> {
            BlockPos blockPos = new BlockPos(chunkPos.m_151390_(), finalheight + 1, chunkPos.m_151393_());
            ArrayList<StructurePiece> list = new ArrayList<StructurePiece>();
            MansionPieces.createMansionLayout(context.f_226621_(), context.f_226625_(), blockPos, blockRotation, list, (RandomSource)random, this.mansionType);
            list.forEach(piece -> {
                if (piece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece poolElementStructurePiece = (PoolElementStructurePiece)piece;
                    structurePiecesBuilder.m_142679_((StructurePiece)new MansionStructurePiece(poolElementStructurePiece, this.mansionType, this.foundationBlock, this.pillarOnlyToLand));
                } else {
                    structurePiecesBuilder.m_142679_(piece);
                }
            });
        }));
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        Object e;
        if (!piecesContainer.m_192748_() && (e = piecesContainer.f_192741_().get(0)) instanceof MansionStructurePiece) {
            MansionStructurePiece mansionStructurePiece = (MansionStructurePiece)((Object)e);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BoundingBox box = piecesContainer.m_192756_();
            int structureBottomY = box.m_162396_();
            int terrainY = Integer.MIN_VALUE;
            for (int x = box.m_162395_(); x <= box.m_162399_(); ++x) {
                block1: for (int z = box.m_162398_(); z <= box.m_162401_(); ++z) {
                    if (chunkPos.f_45578_ != x >> 4 || chunkPos.f_45579_ != z >> 4) continue;
                    mutableBlockPos.m_122178_(x, structureBottomY, z);
                    if (mansionStructurePiece.pillarOnlyToLand && (terrainY = GeneralUtils.getFirstLandYFromPos((LevelReader)level, mutableBlockPos.m_7495_())) <= chunkGenerator.m_142062_() || level.m_46859_((BlockPos)mutableBlockPos) || !box.m_71051_((Vec3i)mutableBlockPos) || !piecesContainer.m_192751_((BlockPos)mutableBlockPos)) continue;
                    for (int currentY = structureBottomY - 1; !(currentY <= chunkGenerator.m_142062_() || mansionStructurePiece.pillarOnlyToLand && currentY <= terrainY); --currentY) {
                        BlockPos blockPos2 = new BlockPos(x, currentY, z);
                        BlockState state = level.m_8055_(blockPos2);
                        if (!level.m_46859_(blockPos2) && state.m_60819_().m_76178_() && !state.m_204336_(BlockTags.f_278411_) && !state.m_204336_(BlockTags.f_13041_)) continue block1;
                        level.m_7731_(blockPos2, mansionStructurePiece.foundationBlock, 2);
                    }
                }
            }
        }
    }

    public StructureType<?> m_213658_() {
        return RSStructures.MANSION_STRUCTURE.get();
    }
}

